/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.websocket;

import com.boshiyuan.util.ToolUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/websocket/{type}")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static final Map<String, Object> connections = new ConcurrentHashMap();
    private Session session;
    private String ids = "";

    @OnOpen
    public void start(Session session, EndpointConfig config, @PathParam(value="username") String type) {
        log.debug("Operator type :" + type + " has connected....");
        this.session = session;
        connections.put(session.getId(), this);
        System.out.println("nsp session_id:" + session.getId());
        String data = "hello, welcome to connect websocket!";
        WebSocketServer.sendTo((String)session.getId(), (String)data);
    }

    @OnClose
    public void end(Session session, CloseReason reason, @PathParam(value="type") String type) {
        connections.remove(this.session.getId());
    }

    @OnMessage
    public void incoming(Session session, String message, @PathParam(value="type") String type) {
        if ("ping".equals("ping")) {
            message = "pong";
        }
        String formatMessage = ToolUtil.HtmlFilter((String)message);
        if ("web".equals(type)) {
            if (message.contains("ids=")) {
                String idsStr = formatMessage.split("=")[1].replace("\"", "");
                this.ids = StringUtils.isNotEmpty((String)this.ids) ? this.ids.concat(",").concat(idsStr) : idsStr;
                this.ids = formatMessage = ToolUtil.strRemoveDuplicate((String)this.ids);
            }
            formatMessage = String.format("\u6d88\u606f %s:%s", type, formatMessage);
        }
        WebSocketServer.sendTo((String)session.getId(), (String)formatMessage);
    }

    @OnError
    public void onError(Throwable t, @PathParam(value="type") String type) throws Throwable {
        log.error("Chat Error: " + t.toString());
    }

    private static void sendTo(String wsSessionId, String msg) {
        WebSocketServer.sendUser((String)wsSessionId, (String)msg);
    }

    public static void sendUser(String wsSessionId, String msg) {
        WebSocketServer c = (WebSocketServer)connections.get(wsSessionId);
        if (c != null) {
            try {
                c.session.getBasicRemote().sendText(msg);
            }
            catch (IOException e) {
                log.debug("Chat Error: Failed to send message to client");
                e.printStackTrace();
                connections.remove(c);
                try {
                    c.session.close();
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
                String message = String.format("* %s", "has been disconnected.");
                WebSocketServer.broadcast((String)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcast(String msg) {
        System.out.println(" n001 size:" + connections.size());
        for (String key : connections.keySet()) {
            System.out.println(" n002 key:" + key);
            WebSocketServer client = null;
            try {
                WebSocketServer webSocketServer = client = (WebSocketServer)connections.get(key);
                synchronized (webSocketServer) {
                    if (client.session.isOpen()) {
                        System.out.println("send nsp001 msg:" + msg);
                        client.session.getBasicRemote().sendText(msg);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                connections.remove(client);
                try {
                    client.session.close();
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
                String message = String.format("* %s", "has been disconnected.Send message failed.");
                WebSocketServer.broadcast((String)message);
            }
        }
    }
}

