/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    private static Logger logger = Logger.getLogger(HttpClientUtil.class);
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String httpurl) {
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpurl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                String line;
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\r\n");
                }
                result = sb.toString();
            }
        }
        catch (IOException e) {
            logger.error((Object)"=======>fail to request!!!");
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            assert (connection != null);
            connection.disconnect();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String httpUrl, String param) {
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            os = connection.getOutputStream();
            os.write(param.getBytes());
            if (connection.getResponseCode() == 200) {
                String line;
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\r\n");
                }
                result = sb.toString();
            }
        }
        catch (IOException e) {
            logger.error((Object)"=======>fail to request!!!");
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            assert (connection != null);
            connection.disconnect();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String httpUrl, String param) {
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            os = connection.getOutputStream();
            os.write(param.getBytes());
            if (connection.getResponseCode() == 200) {
                String line;
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\r\n");
                }
                result = sb.toString();
            }
        }
        catch (IOException e) {
            logger.error((Object)"=======>fail to request!!!");
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            assert (connection != null);
            connection.disconnect();
        }
        return result;
    }

    public static String doPostFile(String httpUrl, String filePath) {
        String result = null;
        HttpURLConnection connection = null;
        String Enter = "\r\n";
        String boundary = "Boundary-b2ede-4066-90b9-fca6ff599c118";
        try {
            String line;
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            connection.connect();
            File file = new File(filePath);
            if (!file.exists()) {
                logger.error((Object)"====>request post send file:\u6587\u4ef6\u4e0d\u5b58\u5728");
                return result;
            }
            FileInputStream fis = new FileInputStream(file);
            DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
            String part1 = "--" + boundary + Enter + "Content-Type: application/*" + Enter + "Content-Disposition: form-data; filename=\"" + file.getName() + "\"; name=\"file\"" + Enter + Enter;
            String part2 = Enter + "--" + boundary + Enter + "Content-Type: text/plain" + Enter + "Content-Disposition: form-data; name=\"name\"" + Enter + Enter + file.getName() + Enter + "--" + boundary + "--";
            logger.info((Object)("====>request post send file body part1: " + part1));
            logger.info((Object)("====>request post send file body part2: " + part2));
            byte[] fileBytes = new byte[fis.available()];
            fis.read(fileBytes);
            dos.writeBytes(part1);
            dos.write(fileBytes);
            dos.writeBytes(part2);
            dos.flush();
            dos.close();
            fis.close();
            logger.info((Object)("====>request post send file: " + connection.getResponseCode()));
            InputStream responseStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));
            StringBuilder message = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                message.append(line);
            }
            logger.info((Object)("====>request post send file return result: " + message));
            result = message.toString();
            connection.disconnect();
        }
        catch (Exception e) {
            logger.info((Object)("====>request post send file error: " + e.getMessage()));
            e.printStackTrace();
        }
        return result;
    }
}

