/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.mapper.DeviceMapper;
import com.boshiyuan.mapper.PhotoMapper;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.NgCountModel;
import com.boshiyuan.model.PhotoModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.PhotoService;
import com.boshiyuan.util.ToolUtil;
import com.boshiyuan.util.UploadUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PhotoServiceImpl
implements PhotoService {
    @Autowired
    private PhotoMapper photoMapper;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private UploadConfig uploadConfig;
    @Value(value="${server.port}")
    private int SERVER_PORT;
    @Value(value="${fileupload.url}")
    private String UPLOAD_IMG_URL;

    public List<PhotoModel> findAll() {
        return this.photoMapper.selectAll();
    }

    public ResultModel findListPage(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        String deviceId = request.getParameter("deviceId");
        String cameraId = request.getParameter("cameraId");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String type = request.getParameter("type");
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        PhotoModel photoModel = new PhotoModel();
        if (StringUtils.isNotEmpty((String)deviceId)) {
            photoModel.setDeviceId(deviceId);
        }
        if (StringUtils.isNotEmpty((String)cameraId)) {
            photoModel.setCameraId(cameraId);
        }
        if (StringUtils.isNotEmpty((String)type)) {
            photoModel.setType(Short.valueOf(Short.parseShort(type)));
        }
        if (StringUtils.isNotEmpty((String)startTime)) {
            long startUtc = ToolUtil.date2TimeStamp((String)startTime, (String)"yyyy-MM-dd HH:mm");
            photoModel.setStartTime(startUtc);
        }
        if (StringUtils.isNotEmpty((String)endTime)) {
            long endUtc = ToolUtil.date2TimeStamp((String)endTime, (String)"yyyy-MM-dd HH:mm");
            photoModel.setEndTime(endUtc);
        }
        List photoList = this.photoMapper.findListPage(photoModel);
        String pathUrl = this.UPLOAD_IMG_URL + ":" + this.SERVER_PORT + "/upload";
        for (int i = 0; i < photoList.size(); ++i) {
            if (((PhotoModel)photoList.get(i)).getUrl().startsWith("http")) continue;
            String imgUrl = pathUrl + ((PhotoModel)photoList.get(i)).getUrl();
            ((PhotoModel)photoList.get(i)).setUrl(imgUrl);
        }
        PageInfo pageInfo = new PageInfo(photoList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public List<NgCountModel> selectPhotoData(PhotoModel photoModel) {
        return this.photoMapper.selectPhotoData(photoModel);
    }

    public ResultModel uploadPhoto(HttpServletRequest request, MultipartFile file) {
        ResultModel resultModel = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        String cameraId = request.getParameter("cameraId");
        String detectId = request.getParameter("detectId");
        String detectResult = request.getParameter("result");
        if (StringUtils.isNotEmpty((String)deviceId) && !file.isEmpty()) {
            DeviceModel device = this.deviceMapper.findOneByDeviceId(deviceId);
            if (device != null) {
                String rootPath = this.uploadConfig.getUploadPath();
                String fileName = file.getOriginalFilename();
                String datePath = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                String uploadPath = rootPath + "/" + deviceId + "/" + datePath;
                if (UploadUtil.uploadFiles((MultipartFile)file, (String)uploadPath, (String)fileName)) {
                    PhotoModel photoModel = new PhotoModel();
                    photoModel.setDeviceId(deviceId);
                    photoModel.setCameraId(cameraId);
                    photoModel.setName(fileName);
                    photoModel.setSize(Long.valueOf(file.getSize()));
                    photoModel.setUrl("/" + deviceId + "/" + datePath + "/" + fileName);
                    if (StringUtils.isNotEmpty((String)detectId)) {
                        photoModel.setDetectId(Integer.valueOf(Integer.parseInt(detectId)));
                    }
                    Date nowDate = new Date();
                    Long nowUtc = nowDate.getTime();
                    photoModel.setNgTime(nowUtc);
                    photoModel.setSaveTime(nowUtc);
                    String ngDate = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss").format(new Date());
                    photoModel.setNgDate(ngDate);
                    if (StringUtils.isNotEmpty((String)detectResult)) {
                        photoModel.setType(Short.valueOf(Short.parseShort(detectResult)));
                    }
                    if (this.photoMapper.insert((Object)photoModel) > 0) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("deviceId", deviceId);
                        hashMap.put("cameraId", cameraId);
                        hashMap.put("filename", fileName);
                        hashMap.put("filesize", file.getSize());
                        resultModel.setResult(hashMap);
                    } else {
                        resultModel.setCode(-1);
                        resultModel.setMsg("\u4fdd\u5b58\u5931\u8d25");
                    }
                } else {
                    resultModel.setCode(-1);
                    resultModel.setMsg("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
                }
            } else {
                resultModel.setCode(-1);
                resultModel.setMsg("\u8be5\u8bbe\u5907\u4e0d\u5b58");
            }
        } else {
            resultModel.setCode(-1);
            resultModel.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return resultModel;
    }

    public int clearPhotoByUtc(long utc) {
        return this.photoMapper.clearPhotoByUtc(utc);
    }
}

