/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.mapper.DeviceMapper;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.DeviceStateModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.model.param.CdnParamModel;
import com.boshiyuan.service.DeviceService;
import com.boshiyuan.service.impl.DeviceServiceImpl;
import com.boshiyuan.util.FFmpegUtils;
import com.boshiyuan.util.ToolUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceServiceImpl
implements DeviceService {
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private UploadConfig uploadConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${server.port}")
    private int SERVER_PORT;
    @Value(value="${fileupload.url}")
    private String UPLOAD_IMG_URL;
    private static Logger logger = Logger.getLogger(DeviceServiceImpl.class);

    public List<DeviceModel> findAll() {
        return this.deviceMapper.selectAll();
    }

    public ResultModel findListPage(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        String groupId = request.getParameter("groupId");
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setState(Short.valueOf((short)-1));
        if (StringUtils.isNotEmpty((String)groupId)) {
            deviceModel.setGroupId(Integer.valueOf(Integer.parseInt(groupId)));
        }
        List deviceList = this.deviceMapper.findListPage(deviceModel);
        PageInfo pageInfo = new PageInfo(deviceList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public ResultModel findStateListPage(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        String groupId = request.getParameter("groupId");
        String stateStr = request.getParameter("state");
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setState(Short.valueOf((short)-1));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)groupId)) {
            map.put("groupId", Integer.parseInt(groupId));
        }
        List deviceList = new ArrayList();
        if (StringUtils.isNotEmpty((String)stateStr)) {
            int state = Integer.parseInt(stateStr);
            map.put("state", state);
            Set keys = new HashSet();
            try {
                keys = this.redisTemplate.keys((Object)"*");
            }
            catch (Exception e) {
                logger.error((Object)("Redis error msg:" + e.getMessage()));
            }
            ArrayList<String> onlineList = new ArrayList<String>();
            for (String key : keys) {
                DeviceStateModel stateModel = this.getStateFromRedis(key);
                if (stateModel == null || stateModel.getHeartbeatState() != 0) continue;
                onlineList.add(stateModel.getDeviceId());
            }
            String deviceIds = String.join((CharSequence)",", onlineList);
            if (state == 1) {
                if (StringUtils.isNotEmpty((String)deviceIds)) {
                    map.put("deviceIds", deviceIds);
                    deviceList = this.deviceMapper.findStateListPage(map);
                    for (int i = 0; i < deviceList.size(); ++i) {
                        if (!onlineList.contains(((DeviceModel)deviceList.get(i)).getDeviceId())) continue;
                        ((DeviceModel)deviceList.get(i)).setHeartbeatState(0);
                    }
                }
            } else if (state == 2) {
                if (StringUtils.isNotEmpty((String)deviceIds)) {
                    map.put("deviceIds", deviceIds);
                }
                deviceList = this.deviceMapper.findStateListPage(map);
            } else {
                deviceList = this.deviceMapper.findStateListPage(map);
                int length = deviceList.size();
                for (int i = 0; i < length; ++i) {
                    if (!onlineList.contains(((DeviceModel)deviceList.get(i)).getDeviceId())) continue;
                    ((DeviceModel)deviceList.get(i)).setHeartbeatState(0);
                }
            }
        } else {
            deviceList = this.deviceMapper.findStateListPage(map);
        }
        PageInfo pageInfo = new PageInfo(deviceList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public ResultModel updateVersion(HashMap hashMap) {
        ResultModel result = new ResultModel();
        String deviceId = null;
        String version = null;
        if (hashMap == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        if (hashMap.containsKey("device_id")) {
            deviceId = String.valueOf(hashMap.get("device_id"));
        }
        if (hashMap.containsKey("device_id")) {
            version = String.valueOf(hashMap.get("version"));
        }
        if (deviceId == null || version == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel device = this.deviceMapper.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setId(device.getId());
        deviceModel.setVersion(version);
        Long time = new Date().getTime();
        deviceModel.setUpdateTime(time);
        if (this.deviceMapper.update(deviceModel) > 0) {
            result.setMsg("\u7248\u672c\u66f4\u65b0\u6210\u529f");
        } else {
            result.setCode(-1);
            result.setMsg("\u7248\u672c\u66f4\u65b0\u5931\u8d25");
        }
        return result;
    }

    public ResultModel getSoftwareRecordList(HttpServletRequest request) {
        return null;
    }

    public DeviceStateModel getStateFromRedis(String deviceId) {
        DeviceStateModel stateModel = null;
        String stateText = null;
        try {
            stateText = (String)this.redisTemplate.boundValueOps((Object)deviceId).get();
        }
        catch (Exception e) {
            logger.error((Object)("Redis error msg:" + e.getMessage()));
        }
        if (stateText != null) {
            JSONObject json = JSON.parseObject((String)stateText);
            stateModel = new DeviceStateModel();
            stateModel.setDeviceId(json.get((Object)"deviceId").toString());
            stateModel.setUuid(json.get((Object)"uuid").toString());
            stateModel.setDeviceBaseinfo(json.get((Object)"deviceBaseinfo").toString());
            stateModel.setDeviceState((String)json.get((Object)"deviceState"));
            Long utc = Long.parseLong(json.get((Object)"utc").toString());
            stateModel.setUtc(utc);
            Long nowUtc = new Date().getTime();
            if (nowUtc - utc >= 10000L) {
                stateModel.setHeartbeat_state(1);
            }
        }
        return stateModel;
    }

    public DeviceModel findOne(int id) {
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setId(Integer.valueOf(id));
        DeviceModel device = this.deviceMapper.findOneById(deviceModel);
        return device;
    }

    public DeviceModel findOneDevice(DeviceModel deviceModel) {
        return (DeviceModel)this.deviceMapper.selectOne((Object)deviceModel);
    }

    public DeviceModel findOneByDeviceId(String deviceId) {
        return this.deviceMapper.findOneByDeviceId(deviceId);
    }

    public int save(DeviceModel deviceModel) {
        return this.deviceMapper.insert((Object)deviceModel);
    }

    public int update(DeviceModel deviceModel) {
        return this.deviceMapper.update(deviceModel);
    }

    public int updateLiveData(DeviceModel deviceModel) {
        return this.deviceMapper.updateLiveData(deviceModel);
    }

    public int delete(int id) {
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setId(Integer.valueOf(id));
        return this.deviceMapper.delete((Object)deviceModel);
    }

    public List<DeviceModel> findDeviceListPage(CdnParamModel paramModel) {
        return this.deviceMapper.findDeviceListPage(paramModel);
    }

    public List<HashMap> getHistoryVideoList(String deviceId) {
        String mediaRootPath = this.uploadConfig.getMediaRoot();
        List mapList = new ArrayList<HashMap>();
        File dir = new File(mediaRootPath);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (!file.isDirectory() || !file.getName().contains(deviceId)) continue;
                try {
                    mapList = this.findMediaFile(file.getAbsolutePath());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return mapList;
    }

    public List<HashMap> findMediaFile(String path) throws IOException {
        ArrayList<HashMap> mapList = new ArrayList<HashMap>();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            HashMap<String, Object> map = null;
            String pathUrl = this.UPLOAD_IMG_URL + ":" + this.SERVER_PORT + "/video/";
            for (int i = 0; i < files.length; ++i) {
                String suffix;
                String fileName;
                map = new HashMap<String, Object>();
                File file = new File(dir, files[i]);
                if (!file.exists() || !file.isFile() || (fileName = file.getName()).lastIndexOf(".") <= -1 || !".mp4".equals(suffix = fileName.substring(fileName.lastIndexOf(".")))) continue;
                String url = pathUrl + dir.getName() + "/" + fileName;
                String mediaText = FFmpegUtils.getMediaInfo((String)file.getAbsolutePath());
                JSONObject json = JSONObject.parseObject((String)mediaText);
                JSONObject formatObj = (JSONObject)json.get((Object)"format");
                Float duration = formatObj.getFloat("duration");
                map.put("name", fileName);
                map.put("url", url);
                map.put("duration", Math.ceil(duration.floatValue()));
                mapList.add(map);
            }
            if (mapList.size() > 0) {
                Collections.sort(mapList, new SortByFileTime(this));
            }
        }
        return mapList;
    }

    public ResultModel getDeviceRecordNgListPage(HttpServletRequest request) {
        long startUtc;
        ResultModel result = new ResultModel();
        String typeStr = request.getParameter("type");
        String deviceId = request.getParameter("deviceId");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String pageNumStr = request.getParameter("pageNum");
        String pageSizeStr = request.getParameter("pageSize");
        int type = StringUtils.isNotEmpty((String)typeStr) ? Integer.parseInt(typeStr) : 0;
        int pageNum = StringUtils.isNotEmpty((String)pageNumStr) ? Integer.parseInt(pageNumStr) : 1;
        int pageSize = StringUtils.isNotEmpty((String)pageSizeStr) ? Integer.parseInt(pageSizeStr) : 6;
        Calendar calendar = Calendar.getInstance();
        long endUtc = startUtc = calendar.getTimeInMillis();
        if (StringUtils.isNotEmpty((String)typeStr)) {
            switch (type) {
                case 0: {
                    calendar.add(10, -11);
                    break;
                }
                case 1: {
                    calendar.add(6, -6);
                    break;
                }
                case 2: {
                    calendar.add(6, -30);
                    break;
                }
                case 3: {
                    calendar.add(2, -11);
                    break;
                }
            }
            startUtc = calendar.getTimeInMillis();
        } else {
            if (StringUtils.isNotEmpty((String)startTime)) {
                startUtc = ToolUtil.date2TimeStamp((String)startTime, (String)"yyyy-MM-dd HH:mm");
            }
            if (StringUtils.isNotEmpty((String)endTime)) {
                endUtc = ToolUtil.date2TimeStamp((String)endTime, (String)"yyyy-MM-dd HH:mm");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)deviceId)) {
            map.put("deviceId", deviceId);
        }
        map.put("startUtc", startUtc);
        map.put("endUtc", endUtc);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List statisticsModelList = this.deviceMapper.findDeviceRecordNgListPage(map);
        PageInfo pageInfo = new PageInfo(statisticsModelList);
        result.setResult((Object)pageInfo);
        return result;
    }
}

