/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.interceptor;

import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.util.JwtUtil;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LoginInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String authorization = request.getHeader("Authorization");
        if (StringUtils.isEmpty((String)authorization)) {
            this.responseJson(response, 403, "\u7528\u6237\u672a\u767b\u5f55\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c\uff01");
            return false;
        }
        String token = authorization.split(" ")[1];
        Claims claims = JwtUtil.verfiyJwt((String)token);
        if (claims != null) {
            request.setAttribute("JWT_CLAIMS", (Object)claims);
            return true;
        }
        this.responseJson(response, 401, "\u65e0\u6548token\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public boolean responseJson(HttpServletResponse response, int code, String msg) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ResultModel result = new ResultModel();
        result.setCode(code);
        result.setMsg(msg);
        response.getWriter().append(result.toString());
        return false;
    }
}

