/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.UserModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.UserService;
import com.boshiyuan.util.ToolUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor17/user"})
public class UserController {
    @Autowired
    private UserService userService;
    private static Logger logger = Logger.getLogger(UserController.class);

    @RequestMapping(path={"/profile/{id}"}, method={RequestMethod.GET})
    public ResultModel profile(@PathVariable(value="id", required=true) long id, HttpServletRequest request) {
        logger.info((Object)">>>>>>>>>>>>/v1/user/profile/query>>>>>start");
        ResultModel result = new ResultModel();
        if (id > 0L) {
            UserModel user = this.userService.findById(Long.valueOf(id));
            if (user != null) {
                result.setResult((Object)user);
            } else {
                result.setCode(-1);
                result.setMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef\uff01");
        }
        return result;
    }

    @RequestMapping(path={"/profile"}, method={RequestMethod.PATCH})
    public ResultModel update(@RequestBody UserModel userModel) {
        ResultModel result = new ResultModel();
        UserModel user = this.userService.findById(userModel.getId());
        if (user == null) {
            result.setCode(-1);
            result.setMsg("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return result;
        }
        if (StringUtils.isNotEmpty((String)userModel.getPassword()) && StringUtils.isNotEmpty((String)userModel.getRepassword())) {
            if (userModel.getPassword().length() < 6) {
                result.setCode(-1);
                result.setMsg("\u5bc6\u7801\u957f\u5ea6\u81f3\u5c116\u4f4d\uff01");
                return result;
            }
            if (!userModel.getPassword().equals(userModel.getRepassword())) {
                result.setCode(-1);
                result.setMsg("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
                return result;
            }
            String salt = ToolUtil.getRandomString((int)10);
            userModel.setPwdSalt(salt);
            StringBuffer sb = new StringBuffer(userModel.getPassword()).append(salt);
            byte[] bytes = sb.toString().getBytes();
            String passwd = ToolUtil.getMD5((byte[])bytes, (int)bytes.length);
            userModel.setPassword(passwd);
        }
        userModel.setUpdateTime(Long.valueOf(new Date().getTime()));
        if (this.userService.update(userModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u66f4\u65b0\u5931\u8d25\uff01");
        }
        return result;
    }

    @RequestMapping(path={"/register"}, method={RequestMethod.POST})
    public ResultModel add(@RequestBody UserModel userModel) {
        return this.userService.save(userModel);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.PATCH})
    public ResultModel userCheck(@RequestBody UserModel userModel) {
        logger.info((Object)">>>>>>>>>>>>/v1/user/check>>>>>start");
        ResultModel result = this.userService.userCheck(userModel);
        logger.info((Object)">>>>>>>>>>>>/v1/user/check>>>>>end");
        return result;
    }

    @RequestMapping(path={"/list"}, method={RequestMethod.GET})
    public ResultModel list(HttpServletRequest request) {
        ResultModel result = this.userService.findUserListPage(request);
        return result;
    }

    @RequestMapping(path={"/delete/{id}"}, method={RequestMethod.DELETE})
    public ResultModel delete(@PathVariable(value="id", required=true) int id) {
        ResultModel result = this.userService.delete((long)id);
        return result;
    }
}

