/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.SystemPropertyModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.SystemPropertyService;
import com.boshiyuan.util.ToolUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/monitor17/system"})
public class SystemPropertyController {
    @Autowired
    private SystemPropertyService systemPropertyService;

    @RequestMapping(path={"/property"}, method={RequestMethod.GET})
    public ResultModel getProperty(HttpServletRequest request) {
        List propertyList = this.systemPropertyService.findAll();
        ResultModel result = new ResultModel();
        if (propertyList != null && propertyList.size() > 0) {
            result.setResult((Object)propertyList);
        }
        return result;
    }

    @RequestMapping(path={"/property/{id}"}, method={RequestMethod.GET})
    public ResultModel getPropertyInfo(@PathVariable(value="id", required=true) int id, HttpServletRequest request) {
        SystemPropertyModel propertyModel = this.systemPropertyService.findOne(id);
        ResultModel result = new ResultModel();
        if (null != propertyModel) {
            result.setResult((Object)propertyModel);
        }
        return result;
    }

    @RequestMapping(path={"/property"}, method={RequestMethod.POST})
    public ResultModel updateProperty(HttpServletRequest request, @RequestBody SystemPropertyModel propertyModel) {
        ResultModel result = new ResultModel();
        System.out.println(propertyModel.toString());
        if (propertyModel != null) {
            propertyModel.setModifyUtc(Long.valueOf(new Date().getTime()));
            String userName = ToolUtil.getUserNameFromToken((HttpServletRequest)request);
            propertyModel.setOperatorId(userName);
            if (this.systemPropertyService.update(propertyModel) < 1) {
                result.setCode(-1);
                result.setMsg("\u66f4\u65b0\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/software/list"}, method={RequestMethod.GET})
    public ResultModel getSoftwareList() {
        return this.systemPropertyService.getSoftwareList();
    }

    @RequestMapping(path={"/software/upload"}, method={RequestMethod.POST})
    public ResultModel uploadSoftware(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        return this.systemPropertyService.uploadSoftware(request, file);
    }

    @RequestMapping(path={"/software/delete"}, method={RequestMethod.DELETE})
    public ResultModel deleteSoftware(HttpServletRequest request) {
        return this.systemPropertyService.deleteSoftware(request);
    }

    @RequestMapping(path={"/software/update"}, method={RequestMethod.POST})
    public ResultModel updateSoftware(HttpServletRequest request) {
        return this.systemPropertyService.updateSoftware(request);
    }

    @RequestMapping(path={"/software/check"}, method={RequestMethod.GET})
    public ResultModel softwareCheck(HttpServletRequest request) {
        return this.systemPropertyService.softwareCheck(request);
    }
}

