/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.UserGroupAccessModel;
import com.boshiyuan.model.UserGroupModel;
import com.boshiyuan.model.UserRuleModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.UserGroupAccessService;
import com.boshiyuan.service.UserGroupService;
import com.boshiyuan.service.UserRuleService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor17/permission"})
public class PermissionController {
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private UserRuleService userRuleService;
    @Autowired
    private UserGroupAccessService groupAccessService;
    private static Logger logger = Logger.getLogger(PermissionController.class);

    @RequestMapping(path={"/role_list"}, method={RequestMethod.GET})
    public ResultModel list(HttpServletRequest request) {
        ResultModel result = this.userGroupService.findAllUserGroup();
        return result;
    }

    @RequestMapping(path={"/role_info/{id}"}, method={RequestMethod.GET})
    public ResultModel info(@PathVariable(value="id", required=true) int id) {
        return this.userGroupService.findOne(id);
    }

    @RequestMapping(path={"/role_add"}, method={RequestMethod.POST})
    public ResultModel add(HttpServletRequest request, @RequestBody UserGroupModel userGroupModel) {
        if (userGroupModel != null) {
            String ip = request.getRemoteAddr();
            userGroupModel.setRegip(ip);
            userGroupModel.setUpdateip(ip);
            Long regTime = new Date().getTime();
            userGroupModel.setRegtime(regTime);
            userGroupModel.setUpdatetime(regTime);
        }
        ResultModel result = this.userGroupService.save(userGroupModel);
        return result;
    }

    @RequestMapping(path={"/role_edit/{id}"}, method={RequestMethod.PUT})
    public ResultModel update(@PathVariable(value="id", required=true) long id, @RequestBody UserGroupModel userGroupModel) {
        userGroupModel.setId(Long.valueOf(id));
        Long updateTime = new Date().getTime();
        userGroupModel.setUpdatetime(updateTime);
        return this.userGroupService.update(userGroupModel);
    }

    @RequestMapping(path={"/role_delete/{id}"}, method={RequestMethod.DELETE})
    public ResultModel role_delete(@PathVariable(value="id", required=true) int id) {
        return this.userGroupService.delete((long)id);
    }

    @RequestMapping(path={"/rule_list"}, method={RequestMethod.GET})
    public ResultModel ruleList(HttpServletRequest request) {
        return this.userRuleService.selectAll();
    }

    @RequestMapping(path={"/rule_edit/{id}"}, method={RequestMethod.PUT})
    public ResultModel updateRule(@PathVariable(value="id", required=true) long id, @RequestBody UserRuleModel userRuleModel) {
        userRuleModel.setId(Long.valueOf(id));
        return this.userRuleService.update(userRuleModel);
    }

    @RequestMapping(path={"/rule_add"}, method={RequestMethod.POST})
    public ResultModel addRule(HttpServletRequest request, @RequestBody UserRuleModel userRuleModel) {
        if (userRuleModel != null) {
            Long addTime = new Date().getTime();
            userRuleModel.setAddtime(addTime);
        }
        ResultModel result = this.userRuleService.save(userRuleModel);
        return result;
    }

    @RequestMapping(path={"/rule_info/{id}"}, method={RequestMethod.GET})
    public ResultModel ruleInfo(@PathVariable(value="id", required=true) int id) {
        return this.userRuleService.findOne(id);
    }

    @RequestMapping(path={"/rule_delete/{id}"}, method={RequestMethod.DELETE})
    public ResultModel delete(@PathVariable(value="id", required=true) int id) {
        return this.userRuleService.delete((long)id);
    }

    @RequestMapping(path={"/access_list"}, method={RequestMethod.GET})
    public ResultModel accessList(HttpServletRequest request) {
        return this.groupAccessService.findAll();
    }

    @RequestMapping(path={"/access_edit/{uid}"}, method={RequestMethod.PUT})
    public ResultModel accessUpdate(@PathVariable(value="uid", required=true) long uid, @RequestBody UserGroupAccessModel accessModel) {
        accessModel.setUid(Long.valueOf(uid));
        return this.groupAccessService.update(accessModel);
    }

    @RequestMapping(path={"/access_add/{uid}"}, method={RequestMethod.POST})
    public ResultModel accessAdd(@RequestBody UserGroupAccessModel accessModel) {
        return this.groupAccessService.save(accessModel);
    }
}

