/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.DeviceGroupModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.DeviceGroupService;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor17/system"})
public class DeviceGroupController {
    @Autowired
    private DeviceGroupService groupService;

    @RequestMapping(path={"/group"}, method={RequestMethod.GET})
    public ResultModel getGroup(HttpServletRequest request) {
        List groupModelList = this.groupService.findAll();
        ResultModel result = new ResultModel();
        if (groupModelList != null && groupModelList.size() > 0) {
            LinkedList<DeviceGroupModel> deviceGroupModelList = new LinkedList<DeviceGroupModel>();
            for (DeviceGroupModel group : groupModelList) {
                if (this.hasChildrenGroup(groupModelList, group).booleanValue()) {
                    LinkedList<DeviceGroupModel> tempGroupModelList = new LinkedList<DeviceGroupModel>();
                    for (DeviceGroupModel group1 : groupModelList) {
                        if (group.getId() != group1.getPid()) continue;
                        tempGroupModelList.add(group1);
                    }
                    group.setChildren(tempGroupModelList);
                    deviceGroupModelList.add(group);
                    continue;
                }
                if (0 != group.getPid()) continue;
                deviceGroupModelList.add(group);
            }
            HashMap<String, LinkedList<DeviceGroupModel>> hashMap = new HashMap<String, LinkedList<DeviceGroupModel>>();
            hashMap.put("list", deviceGroupModelList);
            result.setResult(hashMap);
        }
        return result;
    }

    @RequestMapping(path={"/group/{id}"}, method={RequestMethod.GET})
    public ResultModel getGroupInfo(@PathVariable(value="id", required=true) int id, HttpServletRequest request) {
        DeviceGroupModel deviceGroupModel = this.groupService.findOne(id);
        ResultModel result = new ResultModel();
        if (null != deviceGroupModel) {
            result.setResult((Object)deviceGroupModel);
        }
        return result;
    }

    @RequestMapping(path={"/group"}, method={RequestMethod.POST})
    public ResultModel addGroup(@RequestBody DeviceGroupModel groupModel) {
        ResultModel result = new ResultModel();
        if (groupModel == null || StringUtils.isEmpty((String)groupModel.getName()) || groupModel.getPid() < 0) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        if (groupModel.getPid() > 0) {
            DeviceGroupModel parentGroup = this.groupService.findOne(groupModel.getPid().intValue());
            if (parentGroup == null) {
                result.setCode(-1);
                result.setMsg("\u6240\u5c5e\u7236\u5206\u7ec4\u4e0d\u5b58\u5728");
                return result;
            }
            if (parentGroup.getPid() != 0) {
                result.setCode(-1);
                result.setMsg("\u8bbe\u5907\u5206\u7ec4\u5bf9\u591a\u5230\u4e8c\u7ea7");
                return result;
            }
        }
        Long time = new Date().getTime();
        groupModel.setCreateTime(time);
        groupModel.setUpdateTime(time);
        if (this.groupService.save(groupModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/group"}, method={RequestMethod.PUT})
    public ResultModel updateGroup(@RequestBody DeviceGroupModel groupModel) {
        ResultModel result = new ResultModel();
        if (null != groupModel) {
            groupModel.setUpdateTime(Long.valueOf(new Date().getTime()));
            if (this.groupService.update(groupModel) < 1) {
                result.setCode(-1);
                result.setMsg("\u66f4\u65b0\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/group/{id}"}, method={RequestMethod.DELETE})
    public ResultModel deleteGroup(@PathVariable(value="id", required=true) int id) {
        ResultModel result = new ResultModel();
        if (id > 0) {
            if (this.groupService.delete(id) < 1) {
                result.setCode(-1);
                result.setMsg("\u5220\u9664\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    public Boolean hasChildrenGroup(List<DeviceGroupModel> groupList, DeviceGroupModel group) {
        Boolean bol = false;
        for (DeviceGroupModel groupModel : groupList) {
            if (group.getId() != groupModel.getPid()) continue;
            bol = true;
            break;
        }
        return bol;
    }
}

