/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.DeviceRecordNodeModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.AlarmService;
import com.boshiyuan.service.DeviceRecordNodeService;
import com.boshiyuan.service.DeviceRecordVersionService;
import com.boshiyuan.service.DeviceService;
import com.boshiyuan.service.TemplateService;
import com.boshiyuan.util.ToolUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor17/device"})
public class DeviceController {
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private DeviceRecordNodeService deviceRecordNodeService;
    @Autowired
    private DeviceRecordVersionService recordVersionService;
    @Autowired
    private TemplateService templateService;

    @RequestMapping(path={"/list"}, method={RequestMethod.GET})
    public ResultModel getList(HttpServletRequest request) {
        return this.deviceService.findStateListPage(request);
    }

    @RequestMapping(path={"/info/{id}"}, method={RequestMethod.GET})
    public ResultModel get(@PathVariable(value="id", required=true) int id, HttpServletRequest request) {
        ResultModel result = new ResultModel();
        DeviceModel deviceModel = this.deviceService.findOne(id);
        if (deviceModel != null) {
            result.setResult((Object)deviceModel);
        }
        return result;
    }

    @RequestMapping(path={"/add"}, method={RequestMethod.POST})
    public ResultModel addDevice(@RequestBody DeviceModel deviceModel) {
        ResultModel result = new ResultModel();
        if (deviceModel == null || StringUtils.isEmpty((String)deviceModel.getDeviceId()) || deviceModel.getGroupId() < 1) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceModel.getDeviceId());
        if (device != null) {
            result.setCode(-1);
            result.setMsg("\u8be5\u8bbe\u5907\u5df2\u7ecf\u5b58\u5728");
            return result;
        }
        Long time = new Date().getTime();
        deviceModel.setCreateTime(time);
        deviceModel.setUpdateTime(time);
        deviceModel.setState(Short.valueOf((short)0));
        if (this.deviceService.save(deviceModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/edit"}, method={RequestMethod.PUT})
    public ResultModel updateDevice(@RequestBody DeviceModel deviceModel) {
        ResultModel result = new ResultModel();
        if (deviceModel == null || StringUtils.isEmpty((String)deviceModel.getDeviceId()) || deviceModel.getGroupId() < 1) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceModel.getDeviceId());
        if (device != null && deviceModel.getId() != device.getId()) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u5df2\u7ecf\u5b58\u5728");
            return result;
        }
        deviceModel.setUpdateTime(Long.valueOf(new Date().getTime()));
        if (this.deviceService.update(deviceModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u66f4\u65b0\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/delete/{id}"}, method={RequestMethod.DELETE})
    public ResultModel deleteDevice(@PathVariable(value="id", required=true) int id) {
        ResultModel result = new ResultModel();
        if (id > 0) {
            if (this.deviceService.delete(id) < 1) {
                result.setCode(-1);
                result.setMsg("\u5220\u9664\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/alarm"}, method={RequestMethod.GET})
    public ResultModel getAlarmList(HttpServletRequest request) {
        return this.alarmService.findListPage(request);
    }

    @RequestMapping(path={"/history/video"}, method={RequestMethod.GET})
    public ResultModel getHistoryVideoLit(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("device_id");
        if (StringUtils.isNotEmpty((String)deviceId)) {
            result.setResult((Object)this.deviceService.getHistoryVideoList(deviceId));
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/record/node"}, method={RequestMethod.POST})
    public ResultModel addDeviceRecordNode(@RequestBody DeviceRecordNodeModel recordNodeModel) {
        ResultModel result = new ResultModel();
        if (null == recordNodeModel) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel device = this.deviceService.findOneByDeviceId(recordNodeModel.getDeviceId());
        if (null == device) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        long startUtc = device.getCreateTime();
        DeviceRecordNodeModel lastRecord = this.deviceRecordNodeService.findLastRecord(recordNodeModel.getDeviceId());
        if (lastRecord != null) {
            startUtc = lastRecord.getEndUtc();
        }
        String startDate = ToolUtil.utcToString((long)startUtc, (String)"yyyy-MM-dd HH:mm:ss");
        recordNodeModel.setStartUtc(Long.valueOf(startUtc));
        recordNodeModel.setStartDate(startDate);
        long endUtc = new Date().getTime();
        String endDate = ToolUtil.utcToString((long)endUtc, (String)"yyyy-MM-dd HH:mm:ss");
        recordNodeModel.setEndUtc(Long.valueOf(endUtc));
        recordNodeModel.setEndDate(endDate);
        recordNodeModel.setRemark(recordNodeModel.getRemark());
        if (this.deviceRecordNodeService.save(recordNodeModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u65b0\u589e\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/record/node"}, method={RequestMethod.GET})
    public ResultModel getRecordNodeList(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        if (StringUtils.isNotEmpty((String)deviceId)) {
            List recordNodeModelList = this.deviceRecordNodeService.findRecordNodeList(deviceId);
            int count = recordNodeModelList.size();
            if (count > 0) {
                DeviceRecordNodeModel recordNodeModel = new DeviceRecordNodeModel();
                recordNodeModel.setDeviceId(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getDeviceId());
                recordNodeModel.setStartUtc(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getEndUtc());
                recordNodeModel.setStartDate(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getEndDate());
                recordNodeModel.setEndDate("\u81f3\u4eca");
                recordNodeModelList.add(recordNodeModel);
            }
            result.setResult((Object)recordNodeModelList);
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/record/ng/list"}, method={RequestMethod.GET})
    public ResultModel getDeviceRecordData(HttpServletRequest request) {
        return this.deviceService.getDeviceRecordNgListPage(request);
    }

    @RequestMapping(path={"/software/record"}, method={RequestMethod.GET})
    public ResultModel getDeviceSoftwareRecordList(HttpServletRequest request) {
        return this.recordVersionService.getRecordList(request);
    }

    @RequestMapping(path={"/template/delete/{id}"}, method={RequestMethod.DELETE})
    public ResultModel deleteTemplate(@PathVariable(value="id", required=true) long id) {
        ResultModel result = new ResultModel();
        if (id > 0L) {
            if (this.templateService.deleteTemplateById(Long.valueOf(id)) < 1) {
                result.setCode(-1);
                result.setMsg("\u5220\u9664\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/template/export"}, method={RequestMethod.GET})
    public ResultModel templateExport(HttpServletRequest request) {
        return this.templateService.templateExport(request);
    }
}

