/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 100604
 Source Host           : localhost:3306
 Source Schema         : viewwatch

 Target Server Type    : MySQL
 Target Server Version : 100604
 File Encoding         : 65001

 Date: 14/01/2022 13:17:42
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for camera
-- ----------------------------
DROP TABLE IF EXISTS `camera`;
CREATE TABLE `camera`  (
  `idx` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `camera_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `utc` bigint(20) NULL DEFAULT NULL,
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `cdn_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `live_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `url` varchar(256) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `push_url` varchar(256) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `push_utc` bigint(20) NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `stream_status` tinyint(4) NOT NULL DEFAULT 0,
  `is_record` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`idx`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of camera
-- ----------------------------
INSERT INTO `camera` VALUES (1, '1', 'test', 1640067709000, '', 0, 'cdn001', 'test_1', 'http://192.168.110.209:9999/live/playlist.m3u8?cid=test_1', 'wzb://127.0.0.1/test_1?protocol=1', 1640051735000, 0, 4, 2);
INSERT INTO `camera` VALUES (2, '2', 'test', 1640247362512, NULL, NULL, 'cdn001', 'test_2', 'http://192.168.110.209:9999/live/playlist.m3u8?cid=test_2', 'wzb://127.0.0.1/test_1?protocol=1', 1640245560200, 1, 0, 0);

-- ----------------------------
-- Table structure for camera_copy1
-- ----------------------------
DROP TABLE IF EXISTS `camera_copy1`;
CREATE TABLE `camera_copy1`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '相机位名称',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '设备id',
  `camera_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '相机id',
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '相机状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of camera_copy1
-- ----------------------------
INSERT INTO `camera_copy1` VALUES (1, '1号相机', 'bsy-01', 'camera_01', '1号相机', 1);
INSERT INTO `camera_copy1` VALUES (2, '2号相机', 'bsy-01', 'camera_02', '2号相机', 1);

-- ----------------------------
-- Table structure for device
-- ----------------------------
DROP TABLE IF EXISTS `device`;
CREATE TABLE `device`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备名称',
  `group_id` int(10) NOT NULL DEFAULT 0 COMMENT '设备分组',
  `ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'ip',
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '当前带宽',
  `cdn_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'cdn服务',
  `live_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '视频id',
  `play_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '播放地址',
  `push_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '推流地址',
  `push_utc` bigint(20) NULL DEFAULT NULL COMMENT '推流的utc',
  `stream_status` tinyint(4) NULL DEFAULT NULL COMMENT '流状态',
  `is_record` tinyint(4) NULL DEFAULT 0 COMMENT '0不录制，1--录制',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态',
  `update_time` bigint(20) NULL DEFAULT NULL COMMENT '更新时间',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '创建时间',
  `description` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 19 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of device
-- ----------------------------
INSERT INTO `device` VALUES (1, 'test', '设备01', 1, '127.0.0.10', 0, 'cdn001', 'test', 'http://192.168.110.209:8000/live/playlist.m3u8?cid=test', 'wzb://127.0.0.1/test?protocol=1', 1640245560200, 0, 0, 1, 1641871973462, 1636774164225, '设备01-01', 1);
INSERT INTO `device` VALUES (2, 'bsy-02', '设备02', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1641880217826, 1636774164225, '设备02', 1);
INSERT INTO `device` VALUES (3, 'bsy-03', 'bsy-03', 1, '127.0.0.2', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637398248543, 1637397308024, '设备03-03', 2);
INSERT INTO `device` VALUES (4, 'bsy-04', 'bsy-04', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1641872335263, 1637397435752, 'bsy-04', 3);
INSERT INTO `device` VALUES (5, 'bsy-05', 'bsy-05', 6, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637546505618, 1637546494322, '设备05', 0);
INSERT INTO `device` VALUES (6, 'bsy-06', 'bsy-06', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637551997190, 1637551997190, 'bsy-06', 0);
INSERT INTO `device` VALUES (7, 'bsy-07', 'bsy-07', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637552024442, 1637552024442, '设备07', 0);
INSERT INTO `device` VALUES (8, 'bsy-08', 'bsy-08', 8, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637552789517, 1637552789517, '设备08', 0);
INSERT INTO `device` VALUES (9, 'bsy-09', 'bsy-09', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637552853654, 1637552853654, '设备09', 0);
INSERT INTO `device` VALUES (10, 'bsy-10', 'bsy-10', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637552879355, 1637552879355, '设备10', 0);
INSERT INTO `device` VALUES (11, 'bsy-11', 'bsy-11', 12, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637552906408, 1637552906408, '设备1', 0);
INSERT INTO `device` VALUES (12, 'bsy-12', 'bsy-12', 13, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637562132181, 1637562132181, 's设备12', 0);
INSERT INTO `device` VALUES (13, 'bsy-13', '设备13', 13, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1637634756841, 1637634740473, '设备----13', 0);
INSERT INTO `device` VALUES (17, 'bsy-14', 'bsy-14', 32, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1638759584234, 1638759569310, '设备14', 0);
INSERT INTO `device` VALUES (18, 'bsy-15', 'bsy-15', 1, '127.0.0.1', 0, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1640222717269, 1640222717269, '设备15', 0);

-- ----------------------------
-- Table structure for device_group
-- ----------------------------
DROP TABLE IF EXISTS `device_group`;
CREATE TABLE `device_group`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT 0 COMMENT '父节点id',
  `name` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `update_time` bigint(20) NULL DEFAULT NULL COMMENT '更新时间',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 33 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of device_group
-- ----------------------------
INSERT INTO `device_group` VALUES (1, 0, '博视源', '总公司', 1637808853893, 1636774207866);
INSERT INTO `device_group` VALUES (6, 0, '设备分组01', '设备分组01', 1636774207866, 1636774207866);
INSERT INTO `device_group` VALUES (8, 0, '设备分组03', '设备分组03', 1636774207866, 1636774207866);
INSERT INTO `device_group` VALUES (12, 0, '设备分组04', '设备分组04', 1636774207866, 1636774207866);
INSERT INTO `device_group` VALUES (13, 0, '设备分组05', '设备分组05', 1637374803241, 1637374803241);
INSERT INTO `device_group` VALUES (24, 0, '设备分组06', '设备分组06', 1637803444766, 1637803444766);
INSERT INTO `device_group` VALUES (28, 1, '分公司01', '分公司01', 1641872482206, 1637809001739);
INSERT INTO `device_group` VALUES (29, 1, '分公司02', '分公司02', 1637809157200, 1637809157200);
INSERT INTO `device_group` VALUES (30, 1, '分公司03', '分公司设备03', 1638758557736, 1638758557736);
INSERT INTO `device_group` VALUES (31, 0, '设备分组07', '设备分组07', 1638759069550, 1638759069550);
INSERT INTO `device_group` VALUES (32, 1, '分公司04', '分公司04', 1638759097149, 1638759097149);

-- ----------------------------
-- Table structure for device_record_log
-- ----------------------------
DROP TABLE IF EXISTS `device_record_log`;
CREATE TABLE `device_record_log`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operator` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '操作时间',
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of device_record_log
-- ----------------------------
INSERT INTO `device_record_log` VALUES (1, 'root', 'bsy-01', 1637398483057, '不检测此模');

-- ----------------------------
-- Table structure for photo
-- ----------------------------
DROP TABLE IF EXISTS `photo`;
CREATE TABLE `photo`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `camera_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '相机id',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `detect_id` tinyint(2) NOT NULL DEFAULT 0 COMMENT '检测序号',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '图片文件名',
  `url` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '图片路径',
  `size` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '图片大小',
  `ng_time` bigint(20) NULL DEFAULT NULL COMMENT 'ng的时间',
  `save_time` bigint(20) NULL DEFAULT NULL COMMENT '保存的时间',
  `ng_date` datetime(0) NULL DEFAULT NULL COMMENT 'ng的时间',
  `description` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 105 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of photo
-- ----------------------------
INSERT INTO `photo` VALUES (1, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=923761057,2023294941&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-24 15:25:12', 'ng图片', 0);
INSERT INTO `photo` VALUES (2, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=2529476510,3041785782&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-24 01:55:12', 'ng图片', 1);
INSERT INTO `photo` VALUES (3, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=1635608122,693552335&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-24 01:01:12', 'ng', 0);
INSERT INTO `photo` VALUES (4, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=1732966997,2981886582&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-23 04:25:12', 'ng图片', 1);
INSERT INTO `photo` VALUES (5, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=3659156856,3928250034&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-24 05:25:12', 'ng图片', 1);
INSERT INTO `photo` VALUES (6, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=1476844859,894832600&fm=193&f=GIF', 0, 1637398483057, 1637398483057, '2021-11-24 06:25:12', 'ng图片', 2);
INSERT INTO `photo` VALUES (7, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=3728410568,989468460&fm=193&f=GIF', 0, 1637719197978, 1637398483057, '2021-11-24 07:25:12', 'ng图片', 2);
INSERT INTO `photo` VALUES (8, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=4265852580,160349292&fm=193&f=GIF', 0, 1637719197978, 1637398483057, '2021-11-24 08:25:12', 'ng图片', 2);
INSERT INTO `photo` VALUES (9, '1', 'test', 0, NULL, 'https://t7.baidu.com/it/u=613642211,2728281244&fm=193&f=GIF', 0, 1637719197978, 1637398483057, '2021-11-24 14:25:12', 'ng图片', 1);
INSERT INTO `photo` VALUES (10, '1', 'test', 0, 'n3.jpg', '/bsy-01/2021-12-17/n3.jpg', 0, 1639737416470, 1639737416470, '2021-12-17 18:12:56', NULL, 0);
INSERT INTO `photo` VALUES (11, '1', 'test', 0, 'n3.jpg', '/bsy-01/2021-12-17/n3.jpg', 0, 1639737814681, 1639737814681, '2021-12-17 18:12:34', NULL, 0);
INSERT INTO `photo` VALUES (12, '1', 'test', 0, 'n3.jpg', '/bsy-01/2021-12-17/n3.jpg', 0, 1639738076338, 1639738076338, '2021-12-17 18:12:56', NULL, 0);
INSERT INTO `photo` VALUES (13, 'camera_01', 'test', 0, 'OIP-C.jpg', '/bsy-01/2021-12-17/OIP-C.jpg', 0, 1639739267772, 1639739267772, '2021-12-17 19:12:47', NULL, 0);
INSERT INTO `photo` VALUES (14, 'camera_01', 'test', 0, 'src=http___pic9.nipic.com_20100906_5543461_103418093033_2.jpg&refer=http___pic9.nipic.jfif', '/bsy-01/2021-12-17/src=http___pic9.nipic.com_20100906_5543461_103418093033_2.jpg&refer=http___pic9.nipic.jfif', 112358, 1639740540355, 1639740540355, '2021-12-17 19:12:00', NULL, 0);
INSERT INTO `photo` VALUES (15, 'camera_01', 'test', 0, 'R-C.jpg', '/bsy-01/2021-12-18/R-C.jpg', 176871, 1639789740768, 1639789740768, '2021-12-18 09:12:00', NULL, 0);
INSERT INTO `photo` VALUES (16, 'camera_01', 'test', 0, 'R-C.jpg', '/bsy-01/2021-12-18/R-C.jpg', 176871, 1639789861885, 1639789861885, '2021-12-18 09:12:01', NULL, 0);
INSERT INTO `photo` VALUES (17, 'camera_01', 'test', 0, '1499051176544.jpg', '/bsy-01/2021-12-18/1499051176544.jpg', 387380, 1639789941555, 1639789941555, '2021-12-18 09:12:21', NULL, 0);
INSERT INTO `photo` VALUES (18, 'camera_01', 'test', 0, '1499051176544.jpg', '/bsy-01/2021-12-18/1499051176544.jpg', 387380, 1639791584496, 1639791584496, '2021-12-18 09:12:44', NULL, 0);
INSERT INTO `photo` VALUES (19, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795069196, 1639795069196, '2021-12-18 10:12:49', NULL, 0);
INSERT INTO `photo` VALUES (20, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795074156, 1639795074156, '2021-12-18 10:12:54', NULL, 0);
INSERT INTO `photo` VALUES (21, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795079143, 1639795079143, '2021-12-18 10:12:59', NULL, 0);
INSERT INTO `photo` VALUES (22, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795084142, 1639795084142, '2021-12-18 10:12:04', NULL, 0);
INSERT INTO `photo` VALUES (23, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795089145, 1639795089145, '2021-12-18 10:12:09', NULL, 0);
INSERT INTO `photo` VALUES (24, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795094141, 1639795094141, '2021-12-18 10:12:14', NULL, 0);
INSERT INTO `photo` VALUES (25, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795099150, 1639795099150, '2021-12-18 10:12:19', NULL, 0);
INSERT INTO `photo` VALUES (26, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795104146, 1639795104146, '2021-12-18 10:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (27, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795109140, 1639795109140, '2021-12-18 10:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (28, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795114144, 1639795114144, '2021-12-18 10:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (29, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795119137, 1639795119137, '2021-12-18 10:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (30, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795124139, 1639795124139, '2021-12-18 10:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (31, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795131130, 1639795131130, '2021-12-18 10:12:51', NULL, NULL);
INSERT INTO `photo` VALUES (32, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795136137, 1639795136137, '2021-12-18 10:12:56', NULL, NULL);
INSERT INTO `photo` VALUES (33, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795141145, 1639795141145, '2021-12-18 10:12:01', NULL, NULL);
INSERT INTO `photo` VALUES (34, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795146137, 1639795146137, '2021-12-18 10:12:06', NULL, NULL);
INSERT INTO `photo` VALUES (35, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795919887, 1639795919887, '2021-12-18 10:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (36, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795924884, 1639795924884, '2021-12-18 10:12:04', NULL, NULL);
INSERT INTO `photo` VALUES (37, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795929895, 1639795929895, '2021-12-18 10:12:09', NULL, NULL);
INSERT INTO `photo` VALUES (38, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795934890, 1639795934890, '2021-12-18 10:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (39, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795939881, 1639795939881, '2021-12-18 10:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (40, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795944893, 1639795944893, '2021-12-18 10:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (41, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795949884, 1639795949884, '2021-12-18 10:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (42, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795954898, 1639795954898, '2021-12-18 10:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (43, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795959898, 1639795959898, '2021-12-18 10:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (44, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795964894, 1639795964894, '2021-12-18 10:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (45, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795969889, 1639795969889, '2021-12-18 10:12:49', NULL, NULL);
INSERT INTO `photo` VALUES (46, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795974890, 1639795974890, '2021-12-18 10:12:54', NULL, NULL);
INSERT INTO `photo` VALUES (47, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795979893, 1639795979893, '2021-12-18 10:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (48, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795984899, 1639795984899, '2021-12-18 10:12:04', NULL, NULL);
INSERT INTO `photo` VALUES (49, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795989888, 1639795989888, '2021-12-18 10:12:09', NULL, NULL);
INSERT INTO `photo` VALUES (50, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795994890, 1639795994890, '2021-12-18 10:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (51, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639795999898, 1639795999898, '2021-12-18 10:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (52, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639796004890, 1639796004890, '2021-12-18 10:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (53, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639796009898, 1639796009898, '2021-12-18 10:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (54, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639796014886, 1639796014886, '2021-12-18 10:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (55, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639796019906, 1639796019906, '2021-12-18 10:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (56, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-18/m0.jpg', 13993, 1639796024883, 1639796024883, '2021-12-18 10:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (57, 'camera_01', 'test', 0, '1499051176544.jpg', '/bsy-01/2021-12-18/1499051176544.jpg', 387380, 1639810751260, 1639810751260, '2021-12-18 14:12:11', NULL, NULL);
INSERT INTO `photo` VALUES (58, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987939862, 1639987939862, '2021-12-20 16:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (59, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987944568, 1639987944568, '2021-12-20 16:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (60, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987949563, 1639987949563, '2021-12-20 16:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (61, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987954562, 1639987954562, '2021-12-20 16:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (62, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987959561, 1639987959561, '2021-12-20 16:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (63, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987964562, 1639987964562, '2021-12-20 16:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (64, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987969559, 1639987969559, '2021-12-20 16:12:49', NULL, NULL);
INSERT INTO `photo` VALUES (65, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987974562, 1639987974562, '2021-12-20 16:12:54', NULL, NULL);
INSERT INTO `photo` VALUES (66, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987979553, 1639987979553, '2021-12-20 16:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (67, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987984563, 1639987984563, '2021-12-20 16:12:04', NULL, NULL);
INSERT INTO `photo` VALUES (68, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987989565, 1639987989565, '2021-12-20 16:12:09', NULL, NULL);
INSERT INTO `photo` VALUES (69, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987994570, 1639987994570, '2021-12-20 16:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (70, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639987999574, 1639987999574, '2021-12-20 16:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (71, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988004576, 1639988004576, '2021-12-20 16:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (72, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988009564, 1639988009564, '2021-12-20 16:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (73, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988014570, 1639988014570, '2021-12-20 16:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (74, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988019568, 1639988019568, '2021-12-20 16:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (75, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988024567, 1639988024567, '2021-12-20 16:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (76, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988029569, 1639988029569, '2021-12-20 16:12:49', NULL, NULL);
INSERT INTO `photo` VALUES (77, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988034554, 1639988034554, '2021-12-20 16:12:54', NULL, NULL);
INSERT INTO `photo` VALUES (78, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988039561, 1639988039561, '2021-12-20 16:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (79, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988044569, 1639988044569, '2021-12-20 16:12:04', NULL, NULL);
INSERT INTO `photo` VALUES (80, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988049568, 1639988049568, '2021-12-20 16:12:09', NULL, NULL);
INSERT INTO `photo` VALUES (81, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988054574, 1639988054574, '2021-12-20 16:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (82, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988059557, 1639988059557, '2021-12-20 16:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (83, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988064566, 1639988064566, '2021-12-20 16:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (84, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988069549, 1639988069549, '2021-12-20 16:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (85, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988074560, 1639988074560, '2021-12-20 16:12:34', NULL, NULL);
INSERT INTO `photo` VALUES (86, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988079572, 1639988079572, '2021-12-20 16:12:39', NULL, NULL);
INSERT INTO `photo` VALUES (87, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988084559, 1639988084559, '2021-12-20 16:12:44', NULL, NULL);
INSERT INTO `photo` VALUES (88, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988089563, 1639988089563, '2021-12-20 16:12:49', NULL, NULL);
INSERT INTO `photo` VALUES (89, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988094562, 1639988094562, '2021-12-20 16:12:54', NULL, NULL);
INSERT INTO `photo` VALUES (90, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988099571, 1639988099571, '2021-12-20 16:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (91, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988104571, 1639988104571, '2021-12-20 16:12:04', NULL, NULL);
INSERT INTO `photo` VALUES (92, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988109561, 1639988109561, '2021-12-20 16:12:09', NULL, NULL);
INSERT INTO `photo` VALUES (93, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988114560, 1639988114560, '2021-12-20 16:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (94, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988119565, 1639988119565, '2021-12-20 16:12:19', NULL, NULL);
INSERT INTO `photo` VALUES (95, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988124566, 1639988124566, '2021-12-20 16:12:24', NULL, NULL);
INSERT INTO `photo` VALUES (96, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988129567, 1639988129567, '2021-12-20 16:12:29', NULL, NULL);
INSERT INTO `photo` VALUES (97, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988588030, 1639988588030, '2021-12-20 16:12:08', NULL, NULL);
INSERT INTO `photo` VALUES (98, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988593003, 1639988593003, '2021-12-20 16:12:13', NULL, NULL);
INSERT INTO `photo` VALUES (99, 'camera_01', 'test', 0, 'm0.jpg', '/bsy-01/2021-12-20/m0.jpg', 13993, 1639988597989, 1639988597989, '2021-12-20 16:12:17', NULL, NULL);
INSERT INTO `photo` VALUES (100, 'camera_01', 'test', 0, '微信图片_20211220164010.jpg', '/bsy-01/2021-12-20/微信图片_20211220164010.jpg', 1682364, 1639990394161, 1639990394161, '2021-12-20 16:12:14', NULL, NULL);
INSERT INTO `photo` VALUES (101, '1', 'test', 0, 'image3.jpg', '/bsy-01/2021-12-20/image3.jpg', 355682, 1639998763179, 1639998763179, '2021-12-20 19:12:43', NULL, NULL);
INSERT INTO `photo` VALUES (102, '1', 'test', 1, 'image3.jpg', '/bsy-01/2021-12-20/image3.jpg', 355682, 1639998839285, 1639998839285, '2021-12-20 19:12:59', NULL, NULL);
INSERT INTO `photo` VALUES (103, '1', 'test', 1, 'image3.jpg', '/bsy-01/2021-12-22/image3.jpg', 355682, 1640169894203, 1640169894203, '2021-12-22 18:12:54', NULL, NULL);
INSERT INTO `photo` VALUES (104, '1', 'bsy-02', 1, '1499051176544.jpg', '/bsy-02/2021-12-23/1499051176544.jpg', 387380, 1640227103300, 1640227103300, '2021-12-23 10:12:23', NULL, NULL);

-- ----------------------------
-- Table structure for server
-- ----------------------------
DROP TABLE IF EXISTS `server`;
CREATE TABLE `server`  (
  `id` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `name` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `wan_ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `lan_ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `port` int(10) UNSIGNED NULL DEFAULT NULL,
  `play_port` int(10) NULL DEFAULT NULL COMMENT '播放端口',
  `push_port` int(10) NULL DEFAULT NULL COMMENT '推流端口',
  `domain` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `type` tinyint(4) NOT NULL,
  `online` tinyint(4) NULL DEFAULT 0,
  `enable` tinyint(4) NULL DEFAULT 0,
  `start_utc` bigint(20) NULL DEFAULT 0,
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `input_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `cur_load` int(10) UNSIGNED NULL DEFAULT 0,
  `max_load` int(10) UNSIGNED NULL DEFAULT 0,
  `addr` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `version` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of server
-- ----------------------------
INSERT INTO `server` VALUES ('ccs_001', 'ccs_001', '192.168.110.209', '192.168.110.209', 8000, 1234, 1234, '', 1, 1, 1, 1640067249, 104857600, 314572800, 0, 0, '', '1.0.1');
INSERT INTO `server` VALUES ('cdn001', 'cdn001', '192.168.110.209', '192.168.110.209', 9999, 8000, 6000, '', 2, 1, 1, 1640067259, 128, 314572800, 0, 0, '', '1.1.0');

-- ----------------------------
-- Table structure for stream_position
-- ----------------------------
DROP TABLE IF EXISTS `stream_position`;
CREATE TABLE `stream_position`  (
  `id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `position` bigint(20) NULL DEFAULT NULL,
  `frag_index` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of stream_position
-- ----------------------------
INSERT INTO `stream_position` VALUES ('test_1', 4130959908, 15443);
INSERT INTO `stream_position` VALUES ('test_2', 0, 0);
INSERT INTO `stream_position` VALUES ('test_3', 4130959908, 15444);

-- ----------------------------
-- Table structure for system_properties
-- ----------------------------
DROP TABLE IF EXISTS `system_properties`;
CREATE TABLE `system_properties`  (
  `idx` int(11) NOT NULL AUTO_INCREMENT,
  `logo1` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `logo2` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `factory_name` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `camera_num` int(11) NOT NULL,
  `operator_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `modify_utc` bigint(20) NULL DEFAULT 0,
  `picture_save_day` int(11) NOT NULL DEFAULT 10,
  `video_save_day` int(11) NOT NULL DEFAULT 10,
  `auto_page_reresh` tinyint(4) NOT NULL DEFAULT 30,
  `video_create_model` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`idx`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of system_properties
-- ----------------------------
INSERT INTO `system_properties` VALUES (1, 'BO', 'SHIYUAN', '博视源机器视觉有限公司', 8, 'admin', 1642035510079, 12, 8, 12, 1);

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '登录用户名',
  `password` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '' COMMENT '登录密码',
  `pwd_salt` char(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `tel` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '电话',
  `company` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `mobile` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '手机',
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '邮箱',
  `open` tinyint(1) NULL DEFAULT 1 COMMENT '0=禁用 1=启用',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '添加时间戳',
  `update_time` bigint(20) NULL DEFAULT 0 COMMENT '更新时间戳',
  `last_ip` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `last_time` bigint(20) UNSIGNED NULL DEFAULT NULL COMMENT '最近登陆时间',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0未激活 1激活',
  `logtimes` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `username`(`username`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 27 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user
-- ----------------------------
INSERT INTO `user` VALUES (1, 'admin', '123456', 'YJQyAmTWPo', '18025857253', '博视源视觉机器有限公司', NULL, '694285671@qq.com', 1, 1637562132181, 1641785643671, '127.0.0.1', 1642054567913, 1, 59);
INSERT INTO `user` VALUES (2, 'nsp', '123456', 'wyrzyiEkvx', '18025857255', NULL, '18025857256', '694285670@qq.com', 1, 1637562132181, 1637562132181, '127.0.0.1', 1637562132181, 1, 53);
INSERT INTO `user` VALUES (24, 'root', '123456', '', '13889999999', NULL, '', '', 1, 1637562132181, 1637562132181, '', 1637562132181, 1, 0);
INSERT INTO `user` VALUES (25, 'zhangsan', '123456', '', '13925767678', NULL, '', '', 1, 1637562132181, 1637562132181, '', 1637562132181, 1, 0);

-- ----------------------------
-- Table structure for user_group
-- ----------------------------
DROP TABLE IF EXISTS `user_group`;
CREATE TABLE `user_group`  (
  `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` char(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '管理员名称',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态：1可用|0禁用',
  `rules` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL,
  `regtime` bigint(20) NOT NULL DEFAULT 0,
  `regip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '' COMMENT '添加IP',
  `updatetime` bigint(20) NULL DEFAULT NULL,
  `updateip` char(20) CHARACTER SET gbk COLLATE gbk_chinese_ci NULL DEFAULT NULL COMMENT '修改时间',
  `remark` char(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 36 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_group
-- ----------------------------
INSERT INTO `user_group` VALUES (30, '超级管理员', 1, '438,439,440,442,443,444,445,446,447', 1637562132181, '218.19.156.60', 1637562132181, '127.0.0.1', '超级管理员，管理所有');
INSERT INTO `user_group` VALUES (31, '普通用户组', 1, '438,443,444', 1637562132181, '218.19.156.60', 1637562132181, '127.0.0.1', '');

-- ----------------------------
-- Table structure for user_group_access
-- ----------------------------
DROP TABLE IF EXISTS `user_group_access`;
CREATE TABLE `user_group_access`  (
  `uid` mediumint(8) UNSIGNED NOT NULL,
  `group_id` mediumint(8) UNSIGNED NOT NULL,
  UNIQUE INDEX `uid_group_id`(`uid`, `group_id`) USING BTREE,
  INDEX `uid`(`uid`) USING BTREE,
  INDEX `group_id`(`group_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_group_access
-- ----------------------------
INSERT INTO `user_group_access` VALUES (1, 30);
INSERT INTO `user_group_access` VALUES (2, 31);
INSERT INTO `user_group_access` VALUES (3, 31);
INSERT INTO `user_group_access` VALUES (4, 31);
INSERT INTO `user_group_access` VALUES (19, 31);
INSERT INTO `user_group_access` VALUES (20, 32);
INSERT INTO `user_group_access` VALUES (21, 31);
INSERT INTO `user_group_access` VALUES (22, 31);
INSERT INTO `user_group_access` VALUES (23, 31);
INSERT INTO `user_group_access` VALUES (24, 30);
INSERT INTO `user_group_access` VALUES (25, 30);
INSERT INTO `user_group_access` VALUES (26, 30);
INSERT INTO `user_group_access` VALUES (27, 41);
INSERT INTO `user_group_access` VALUES (28, 30);
INSERT INTO `user_group_access` VALUES (29, 31);
INSERT INTO `user_group_access` VALUES (30, 31);
INSERT INTO `user_group_access` VALUES (31, 30);
INSERT INTO `user_group_access` VALUES (32, 32);
INSERT INTO `user_group_access` VALUES (33, 30);
INSERT INTO `user_group_access` VALUES (34, 30);

-- ----------------------------
-- Table structure for user_rule
-- ----------------------------
DROP TABLE IF EXISTS `user_rule`;
CREATE TABLE `user_rule`  (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` char(80) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `title` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT 1,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `css` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '样式',
  `condition` char(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `pid` int(5) NOT NULL DEFAULT 0 COMMENT '父栏目ID',
  `level` int(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '菜单等级',
  `sort` int(11) NOT NULL DEFAULT 0 COMMENT '排序',
  `addtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of user_rule
-- ----------------------------
INSERT INTO `user_rule` VALUES (1, '/video/list', '视频监控', 1, 1, 'el-icon-monitor', '', 0, 0, 1, 1637562132181);
INSERT INTO `user_rule` VALUES (2, '/user/list', '用户管理', 1, 1, 'el-icon-user-solid', '', 0, 0, 1, 1637562132181);
INSERT INTO `user_rule` VALUES (3, '', '系统设置', 1, 1, 'el-icon-settings', '', 0, 0, 1, 1637562132181);
INSERT INTO `user_rule` VALUES (4, '/settings/device_list', '设备管理', 1, 1, '', '', 3, 0, 1, 1637562132181);
INSERT INTO `user_rule` VALUES (5, '/user/list', '用户管理', 1, 1, NULL, '', 3, 0, 1, 1637562132181);
INSERT INTO `user_rule` VALUES (6, '/settings/system_property', '系统参数', 1, 1, '', '', 3, 0, 1, 1637562132181);

-- ----------------------------
-- Table structure for vod
-- ----------------------------
DROP TABLE IF EXISTS `vod`;
CREATE TABLE `vod`  (
  `id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `meta` tinyint(4) NOT NULL DEFAULT 0,
  `file_type` tinyint(4) NOT NULL DEFAULT 0,
  `byte_len` bigint(20) NULL DEFAULT 0,
  `time_len` int(11) NULL DEFAULT 0,
  `bitrate` int(10) UNSIGNED NULL DEFAULT 0,
  `name` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `create_utc` bigint(20) NOT NULL DEFAULT 0,
  `end_utc` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of vod
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
