#############################################################
#                  MODEL       : viewwatch                  #
#                  AUTHOR      : xxxxxx                     #
#############################################################
SET NAMES utf8;

###########  创建数据库 ##############
DROP DATABASE IF EXISTS viewwatch;
CREATE DATABASE IF NOT EXISTS viewwatch CHARACTER SET utf8;

############### 建表 ################
USE viewwatch;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for alarm
-- ----------------------------
DROP TABLE IF EXISTS `alarm`;
CREATE TABLE `alarm`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '报警记录uid，同一设备不重复',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `start_utc` bigint(20) NULL DEFAULT NULL COMMENT '报警开始时间戳',
  `end_utc` bigint(20) NULL DEFAULT NULL COMMENT '报警结束时间戳',
  `detect_id` tinyint(1) NULL DEFAULT NULL COMMENT '检测序号0:成品检测 1：模腔检测',
  `remark` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '报警说明',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 29 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for camera
-- ----------------------------
DROP TABLE IF EXISTS `camera`;
CREATE TABLE `camera`  (
  `idx` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `camera_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `utc` bigint(20) NULL DEFAULT NULL,
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `cdn_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `live_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `url` varchar(256) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `push_url` varchar(256) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `push_utc` bigint(20) NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `stream_status` tinyint(4) NOT NULL DEFAULT 0,
  `is_record` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`idx`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for device
-- ----------------------------
DROP TABLE IF EXISTS `device`;
CREATE TABLE `device`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '设备名称',
  `group_id` int(11) NOT NULL DEFAULT 0 COMMENT '设备分组',
  `ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'ip',
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '当前带宽',
  `cdn_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'cdn服务',
  `live_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '视频id',
  `camera_num` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '相机数',
  `play_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '播放地址',
  `push_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '推流地址',
  `push_utc` bigint(20) NULL DEFAULT NULL COMMENT '推流的utc',
  `stream_status` tinyint(4) NULL DEFAULT NULL COMMENT '流状态',
  `is_record` tinyint(4) NULL DEFAULT 0 COMMENT '0不录制，1--录制',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态',
  `update_time` bigint(20) NULL DEFAULT NULL COMMENT '更新时间',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '创建时间',
  `description` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for device_group
-- ----------------------------
DROP TABLE IF EXISTS `device_group`;
CREATE TABLE `device_group`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT 0 COMMENT '父节点id',
  `name` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL,
  `update_time` bigint(20) NULL DEFAULT NULL COMMENT '更新时间',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;
INSERT INTO device_group VALUES (1,0,'博士源','总公司',REPLACE(unix_timestamp(NOW(3)), '.', ''), REPLACE(unix_timestamp(NOW(3)), '.', ''));

-- ----------------------------
-- Table structure for device_record_log
-- ----------------------------
DROP TABLE IF EXISTS `device_record_log`;
CREATE TABLE `device_record_log`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `operator` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `recordtime` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作时间',
  `description` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '保存时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for device_record_node
-- ----------------------------
DROP TABLE IF EXISTS `device_record_node`;
CREATE TABLE `device_record_node`  (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `start_utc` bigint(20) NULL DEFAULT NULL COMMENT '开始的utc',
  `start_date` datetime(0) NULL DEFAULT NULL COMMENT '其实日期',
  `end_utc` bigint(20) NOT NULL COMMENT '开始utc',
  `end_date` datetime(0) NOT NULL COMMENT '开始的时间',
  `remark` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ng_statistics
-- ----------------------------
DROP TABLE IF EXISTS `ng_statistics`;
CREATE TABLE `ng_statistics`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `utc` bigint(20) NULL DEFAULT NULL COMMENT '检测时间',
  `ng_date` datetime(0) NULL DEFAULT NULL COMMENT 'ng日期',
  `state` tinyint(1) NULL DEFAULT NULL COMMENT ' 0：ng   1：ok',
  `camera` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '相机id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for photo
-- ----------------------------
DROP TABLE IF EXISTS `photo`;
CREATE TABLE `photo`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `camera_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '相机id',
  `device_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '设备id',
  `detect_id` tinyint(4) NOT NULL DEFAULT 0 COMMENT '检测序号',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '图片文件名',
  `url` varchar(512) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '图片路径',
  `size` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '图片大小',
  `ng_time` bigint(20) NULL DEFAULT NULL COMMENT 'ng的时间',
  `save_time` bigint(20) NULL DEFAULT NULL COMMENT '保存的时间',
  `ng_date` datetime(0) NULL DEFAULT NULL COMMENT 'ng的时间',
  `description` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '类型0:ok|1:ng',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for server
-- ----------------------------
DROP TABLE IF EXISTS `server`;
CREATE TABLE `server`  (
  `id` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `name` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `wan_ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `lan_ip` char(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `port` int(10) UNSIGNED NULL DEFAULT NULL,
  `play_port` int(11) NULL DEFAULT NULL COMMENT '播放端口',
  `push_port` int(11) NULL DEFAULT NULL COMMENT '推流端口',
  `domain` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `type` tinyint(4) NOT NULL,
  `online` tinyint(4) NULL DEFAULT 0,
  `enable` tinyint(4) NULL DEFAULT 0,
  `start_utc` bigint(20) NULL DEFAULT 0,
  `output_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `input_bw` int(10) UNSIGNED NULL DEFAULT 0,
  `cur_load` int(10) UNSIGNED NULL DEFAULT 0,
  `max_load` int(10) UNSIGNED NULL DEFAULT 0,
  `addr` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `version` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

INSERT INTO server
(`id`, `name`, `wan_ip`, `lan_ip`, `port`, `type`, `online`, `enable`, `output_bw`, `input_bw`)
VALUES
    ('ccs_001', 'ccs_001', '192.168.103.7', '192.168.103.7', 10432, 1, 1, 1, 104857600, 314572800);
INSERT INTO server
(`id`, `name`, `wan_ip`, `lan_ip`, `port`,`play_port`,`push_port`,`type`, `online`, `enable`, `output_bw`, `input_bw`)
VALUES
    ('cdn001', 'cdn001', '192.168.103.7', '192.168.103.7', 9999, 9901, 6000, 2, 1, 1, 39008, 314572800);

-- ----------------------------
-- Table structure for stream_position
-- ----------------------------
DROP TABLE IF EXISTS `stream_position`;
CREATE TABLE `stream_position`  (
  `id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `pos` bigint(20) NULL DEFAULT NULL,
  `frag_index` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for system_properties
-- ----------------------------
DROP TABLE IF EXISTS `system_properties`;
CREATE TABLE `system_properties`  (
  `idx` int(11) NOT NULL AUTO_INCREMENT,
  `logo1` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `logo2` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `factory_name` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `camera_num` int(11) NOT NULL,
  `operator_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `modify_utc` bigint(20) NULL DEFAULT 0,
  `picture_save_day` int(11) NOT NULL DEFAULT 10,
  `video_save_day` int(11) NOT NULL DEFAULT 10,
  `auto_page_reresh` tinyint(4) NOT NULL DEFAULT 30,
  `video_create_model` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`idx`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;
INSERT INTO system_properties VALUES (1, 'BO', 'SHIYUAN', 'TECHNOLOGY', 8, 'admin', REPLACE(unix_timestamp(NOW(3)), '.', ''), 10, 10, 30, 0);

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '登录用户名',
  `password` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '' COMMENT '登录密码',
  `pwd_salt` char(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `tel` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '电话',
  `company` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '公司名称',
  `mobile` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '手机',
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '邮箱',
  `open` tinyint(1) NULL DEFAULT 1 COMMENT '0=禁用 1=启用',
  `create_time` bigint(20) NULL DEFAULT NULL COMMENT '添加时间戳',
  `update_time` bigint(20) NULL DEFAULT 0 COMMENT '更新时间戳',
  `last_ip` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '',
  `last_time` bigint(20) UNSIGNED NULL DEFAULT NULL COMMENT '最近登陆时间',
  `status` tinyint(1) NULL DEFAULT 0 COMMENT '0未激活 1激活',
  `logtimes` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `username`(`username`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;
INSERT INTO user
(`id`,`username`,`password`,`pwd_salt`,`tel`,`open`,`create_time`,`update_time`,`status`,`logtimes`)
VALUES (1, 'admin', '469C9B39F150D89D9A130F086DE18AB8', 'sUerqVW26p', '18012345678', 1, REPLACE(unix_timestamp(NOW(3)), '.', ''), REPLACE(unix_timestamp(NOW(3)), '.', ''), 1, 0);

    -- ----------------------------
-- Table structure for vod
-- ----------------------------
DROP TABLE IF EXISTS `vod`;
CREATE TABLE `vod`  (
  `id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `meta` tinyint(4) NOT NULL DEFAULT 0,
  `file_type` tinyint(4) NOT NULL DEFAULT 0,
  `byte_len` bigint(20) NULL DEFAULT 0,
  `time_len` int(11) NULL DEFAULT 0,
  `bitrate` int(10) UNSIGNED NULL DEFAULT 0,
  `name` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT '',
  `create_utc` bigint(20) NOT NULL DEFAULT 0,
  `end_utc` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for vod_resource
-- ----------------------------
DROP TABLE IF EXISTS `vod_resource`;
CREATE TABLE `vod_resource`  (
  `idx` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cds_id` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `media_id` char(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `file_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `path` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `meta` tinyint(4) NOT NULL DEFAULT 0,
  `file_type` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`idx`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
