/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.util;

import com.boshiyuan.util.JwtUtil;
import io.jsonwebtoken.Claims;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ToolUtil {
    public static String getHostReqFrom(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getMD5(byte[] bytes, int length) {
        String result = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes, 0, length);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            result = new String(str).toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getHostName() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return "http://" + address.getHostAddress();
    }

    public static long date2TimeStamp(String date_str, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(date_str).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long string2utc(String timeStr, int timeZoneIndex, String format) {
        TimeZone timeZone = timeZoneIndex == 0 ? TimeZone.getTimeZone("GMT") : (timeZoneIndex < 0 ? TimeZone.getTimeZone("GMT" + timeZoneIndex) : TimeZone.getTimeZone("GMT+" + timeZoneIndex));
        SimpleDateFormat sf = new SimpleDateFormat(format);
        sf.setTimeZone(timeZone);
        try {
            Date date = sf.parse(timeStr);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int getMonthDayFromDate(String dateStr, String format) {
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        int day = 0;
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = new SimpleDateFormat(format).parse(dateStr);
            calendar.setTime(date);
            day = calendar.get(5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return day;
    }

    public static String utc2String(long utc, int timeZoneIndex, String format) {
        TimeZone timeZone = null;
        timeZone = timeZoneIndex == 0 ? TimeZone.getTimeZone("GMT") : (timeZoneIndex < 0 ? TimeZone.getTimeZone("GMT" + timeZoneIndex) : TimeZone.getTimeZone("GMT+" + timeZoneIndex));
        SimpleDateFormat sf = new SimpleDateFormat(format);
        sf.setTimeZone(timeZone);
        return sf.format(new Date(utc));
    }

    public static String utcToString(long utc, String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(new Date(utc));
    }

    public static Date stringToDate(String dateStr, String format) {
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        try {
            return sf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String DateToString(Date date, String format) {
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(date);
    }

    public static String getUserNameFromToken(HttpServletRequest request) {
        String userName = "";
        String authorization = request.getHeader("Authorization");
        if (StringUtils.isNotEmpty((String)authorization)) {
            String token = authorization.split(" ")[1];
            Claims claims = JwtUtil.verfiyJwt((String)token);
            userName = (String)claims.get((Object)"userName");
        }
        return userName;
    }

    public static ArrayList getTimeByHour(Date startDate, Date endDate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        while (endDate.compareTo(startDate) >= 0) {
            cal.setTime(startDate);
            String date = ToolUtil.DateToString((Date)startDate, (String)"yyyy-MM-dd HH");
            arrayList.add(date);
            cal.add(10, 1);
            startDate = cal.getTime();
        }
        return arrayList;
    }

    public static ArrayList getDateByDay(Date startDate, Date endDate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        while (endDate.compareTo(startDate) >= 0) {
            cal.setTime(startDate);
            String date = ToolUtil.DateToString((Date)startDate, (String)"yyyy-MM-dd");
            arrayList.add(date);
            cal.add(5, 1);
            startDate = cal.getTime();
        }
        return arrayList;
    }

    public static ArrayList getDateByMonth(Date startDate, Date endDate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        while (endDate.compareTo(startDate) >= 0) {
            cal.setTime(startDate);
            String date = ToolUtil.DateToString((Date)startDate, (String)"yyyy-MM");
            arrayList.add(date);
            cal.add(2, 1);
            startDate = cal.getTime();
        }
        return arrayList;
    }

    public static ArrayList getDateByYear(Date startDate, Date endDate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Calendar cal = Calendar.getInstance();
        while (endDate.compareTo(startDate) >= 0) {
            cal.setTime(startDate);
            String date = ToolUtil.DateToString((Date)startDate, (String)"yyyy");
            arrayList.add(date);
            cal.add(1, 1);
            startDate = cal.getTime();
        }
        return arrayList;
    }

    public static void mkdirs(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String HtmlFilter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("<");
                    continue block6;
                }
                case '>': {
                    result.append(">");
                    continue block6;
                }
                case '&': {
                    result.append("&");
                    continue block6;
                }
                case '\"': {
                    result.append("\"");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String strRemoveDuplicate(String str) {
        String result = "";
        if (StringUtils.isNotEmpty((String)str)) {
            String[] strArray = str.split(",");
            LinkedHashSet<String> hashSet = new LinkedHashSet<String>();
            for (int i = 0; i < strArray.length; ++i) {
                hashSet.add(strArray[i]);
            }
            result = StringUtils.join((Object[])hashSet.toArray(), (String)",");
        }
        return result;
    }

    public static Boolean dateStrIsValid(String dateStr, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dateFormat.parse(dateStr);
            return dateStr.equals(dateFormat.format(date));
        }
        catch (ParseException e) {
            return false;
        }
    }
}

