/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public class CustomLocalTimeDeserializer
extends StdDeserializer<LocalTime> {
    public CustomLocalTimeDeserializer() {
        this(null);
    }

    public CustomLocalTimeDeserializer(Class<?> vc) {
        super(vc);
    }

    public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String dateString = p.getText();
        try {
            OffsetDateTime dateTime = OffsetDateTime.parse(dateString);
            return dateTime.toLocalTime();
        }
        catch (Exception e) {
            return LocalTime.parse(dateString);
        }
    }
}

