/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.task;

import com.alibaba.fastjson.JSONObject;
import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.MediaModel;
import com.boshiyuan.model.ServerModel;
import com.boshiyuan.model.SystemPropertyModel;
import com.boshiyuan.service.DeviceService;
import com.boshiyuan.service.PhotoService;
import com.boshiyuan.service.ServerService;
import com.boshiyuan.service.SystemPropertyService;
import com.boshiyuan.util.FFmpegUtils;
import com.boshiyuan.util.HttpClientUtil;
import com.boshiyuan.util.ToolUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduleTask {
    private static Logger logger = Logger.getLogger(ScheduleTask.class);
    @Autowired
    private ServerService serverService;
    @Value(value="${server.port}")
    private int SERVER_PORT;
    @Autowired
    private UploadConfig uploadConfig;
    @Autowired
    private SystemPropertyService systemPropertyService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private PhotoService photoService;
    private ExecutorService executorService = new ThreadPoolExecutor(10, 20, 50L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(20), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    @Scheduled(fixedRate=30000L)
    public void sendDetectToCdn() {
        String result = null;
        ServerModel server = this.serverService.findOneByServerId("cdn001");
        if (server != null) {
            String ip = StringUtils.isNotEmpty((String)server.getWanIp()) ? server.getWanIp() : server.getLanIp();
            String url = "http://" + server.getLanIp() + ":" + server.getPort() + "/cdn/detect";
            logger.info((Object)("=======>detect to cdn url:" + url));
            String param = "{ \"cdnsid\": \"ccs_001\", \"cdns_port\": " + this.SERVER_PORT + "}";
            logger.info((Object)("=======>detect to cdn param:\r\n" + param));
            result = HttpClientUtil.doPostJson((String)url, (String)param);
        } else {
            logger.error((Object)"=======>detect to cdn result:no available cdn server");
        }
        logger.info((Object)("=======>detect to cdn result:\r\n" + result));
    }

    @Scheduled(fixedRate=60000L, initialDelay=30000L)
    public void cleanPhotoFile() {
        List propertyList = this.systemPropertyService.findAll();
        int savePictureDay = 30;
        int saveVideoDay = 3;
        int saveNgVideoDay = 3;
        for (SystemPropertyModel propertyModel : propertyList) {
            savePictureDay = propertyModel.getPictureSaveDay() > 0 ? propertyModel.getPictureSaveDay() : savePictureDay;
            saveVideoDay = propertyModel.getVideoSaveDay() > 0 ? propertyModel.getVideoSaveDay() : saveVideoDay;
            saveNgVideoDay = propertyModel.getNgVideoSaveDay() > 0 ? propertyModel.getNgVideoSaveDay() : saveNgVideoDay;
        }
        Double freeSpace = (double)this.getHardDiskFreeInfo() * 1.0 / 1024.0 / 1024.0 / 1024.0;
        if (freeSpace > 0.0 && freeSpace < 2.0) {
            savePictureDay = 5;
            saveVideoDay = 3;
            saveNgVideoDay = 3;
        }
        logger.info((Object)("=======>\u56fe\u7247\u4fdd\u5b58\u7684\u5929\u6570:" + savePictureDay + ",\u89c6\u9891\u4fdd\u5b58\u7684\u5929\u6570\uff1a" + saveVideoDay));
        String rootPath = this.uploadConfig.getUploadPath();
        String imgPath = rootPath + "resultpic";
        logger.info((Object)"=============\u5b9a\u671f\u6e05\u9664\u56fe\u7247\u6587\u4ef6====================");
        this.clearImageFolderFromDir(imgPath, savePictureDay);
        logger.info((Object)"=============\u5b9a\u671f\u6e05\u9664\u89c6\u9891\u6587\u4ef6====================");
        String rootVideoPath = this.uploadConfig.getMediaRoot();
        this.clearVideoFolderFromDir(rootVideoPath, saveVideoDay);
        logger.info((Object)"=============\u5b9a\u671f\u6e05\u9664\u56fe\u7247\u6570\u636e\u5e93\u8bb0\u5f55===============");
        this.clearPhotoDBData(savePictureDay);
        logger.info((Object)"=============\u5b9a\u671f\u6e05\u7406NG\u89c6\u9891\u8bb0\u5f55===============");
        String ngVideoPath = rootPath + "ngvideo";
        this.clearNgVideoFromDir(ngVideoPath, saveNgVideoDay);
    }

    @Scheduled(fixedRate=3600000L, initialDelay=60000L)
    public void makeDeviceMediaMp4() {
        List deviceList = this.deviceService.findAll();
        for (DeviceModel device : deviceList) {
            this.executorService.execute(() -> {
                try {
                    this.handleExecute(device);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Scheduled(cron="0 59 23 * * ?")
    public void doLogBak() {
        logger.info((Object)"=============\u5b9a\u671f\u5907\u4efd\u5e76\u6e05\u7406\u8fc7\u671f\u65e5\u5fd7LOG\u6587\u4ef6===============");
        String logName = "boshiyuan-api-viewwatch.log";
        String formDate = ToolUtil.utcToString((long)new Date().getTime(), (String)"yyyy-MM-dd");
        String bakLogFile = "logs/boshiyuan-api-viewwatch_" + formDate + ".log";
        ApplicationHome home = new ApplicationHome(this.getClass());
        File jarFile = home.getSource();
        String jarPath = jarFile.getParentFile().getPath();
        String logPath = jarPath + "/" + logName;
        File logFile = new File(logPath);
        if (logFile.exists() && logFile.isFile()) {
            try {
                File bakFile = new File(jarPath + "/" + bakLogFile);
                FileUtils.copyFile((File)logFile, (File)bakFile);
                this.clearFileLog(logFile);
                this.deleteFileLog(jarPath + "/logs");
            }
            catch (IOException e) {
                logger.info((Object)("do bak log error:" + e.getMessage()));
            }
        }
    }

    public void handleExecute(DeviceModel device) throws IOException {
        logger.info((Object)("=======>\u5f53\u524d\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName()));
        String mediaRootPath = this.uploadConfig.getMediaRoot();
        File dir = new File(mediaRootPath);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (!file.isDirectory() || !file.getName().contains(device.getDeviceId())) continue;
                this.handleMediaFile(file.getAbsolutePath());
            }
        }
    }

    public void handleMediaFile(String path) throws IOException {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                String suffix;
                String fileName;
                MediaModel media = null;
                File file = new File(dir, files[i]);
                if (!file.exists() || !file.isFile() || (fileName = file.getName()).lastIndexOf(".") <= -1 || !".ts".equals(suffix = fileName.substring(fileName.lastIndexOf(".")))) continue;
                String mediaText = FFmpegUtils.getMediaInfo((String)file.getAbsolutePath());
                JSONObject json = JSONObject.parseObject((String)mediaText);
                JSONObject formatObj = (JSONObject)json.get((Object)"format");
                media = new MediaModel();
                Float startTime = formatObj.getFloat("start_time");
                Float duration = formatObj.getFloat("duration");
                media.setFilename(String.valueOf(formatObj.get((Object)"filename")));
                media.setStartTime(startTime.floatValue());
                media.setDuration(duration.floatValue());
                media.setSize(formatObj.getLongValue("size"));
                logger.info((Object)("=======>\u5a92\u4f53\u6587\u4ef6\u4fe1\u606f\uff1a" + media));
                String offsetTime = "0";
                String distRootPath = file.getParent();
                String videoPath = file.getAbsolutePath();
                if (formatObj.getLongValue("size") > 3600L) {
                    offsetTime = String.valueOf(formatObj.getFloat("duration").floatValue() - 3600.0f);
                }
                String date = ToolUtil.utcToString((long)new Date().getTime(), (String)"yyyy-MM-dd-HH-mm-ss");
                String distPath = distRootPath + "/" + date + ".mp4";
                FFmpegUtils.cutVideo((String)videoPath, (String)distPath, (String)offsetTime, (String)"3600");
                FileUtils.delete((File)file);
            }
        }
    }

    public long getHardDiskFreeInfo() {
        File[] files;
        long freeSpace = 0L;
        long totalSpace = 0L;
        for (File file : files = File.listRoots()) {
            freeSpace += file.getFreeSpace();
            totalSpace += file.getTotalSpace();
        }
        String total = new DecimalFormat("#.#").format((double)totalSpace * 1.0 / 1024.0 / 1024.0 / 1024.0) + "G";
        String free = new DecimalFormat("#.#").format((double)freeSpace * 1.0 / 1024.0 / 1024.0 / 1024.0) + "G";
        logger.info((Object)("=======>\u786c\u76d8\u603b\u5185\u5b58\uff1a" + total + ",\u53ef\u7528\u5185\u5b58\uff1a" + free));
        return freeSpace;
    }

    private void clearImageFolderFromDir(String path, int day) {
        LocalDate lastDate = LocalDate.now().minusDays(day);
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (!file.isDirectory()) continue;
                if (ToolUtil.dateStrIsValid((String)file.getName(), (String)"yyyy-MM-dd").booleanValue()) {
                    if (lastDate.toString().compareTo(file.getName()) <= 0) continue;
                    try {
                        FileUtils.deleteDirectory((File)new File(file.getAbsolutePath()));
                        logger.info((Object)("=======>\u6587\u4ef6\u6e05\u7406\u6210\u529f\uff1a" + file.getName()));
                    }
                    catch (Exception e) {
                        logger.info((Object)("=======>\u6587\u4ef6\u6e05\u7406\u5931\u8d25\uff1a" + file.getName()));
                    }
                    continue;
                }
                String tmpPath = file.getAbsolutePath();
                this.clearImageFolderFromDir(tmpPath, day);
            }
        }
    }

    private void clearPhotoDBData(int day) {
        LocalDate lastDate = LocalDate.now().minusDays(day);
        logger.info((Object)("=======>\u56fe\u7247\u6587\u4ef6\u8fc7\u671f\u65f6\u95f4\u70b9\uff1a" + lastDate));
        long utc = ToolUtil.date2TimeStamp((String)lastDate.toString(), (String)"yyyy-MM-dd");
        this.photoService.clearPhotoByUtc(utc);
    }

    private void clearVideoFolderFromDir(String path, int day) {
        LocalDate lastDate = LocalDate.now().minusDays(day);
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                String fileName = file.getName();
                if (file.isFile()) {
                    String videoName;
                    if (fileName.lastIndexOf(".") <= -1 || !ToolUtil.dateStrIsValid((String)(videoName = fileName.substring(0, fileName.lastIndexOf("."))), (String)"yyyy-MM-dd-HH-mm-ss").booleanValue() || lastDate.toString().compareTo(videoName) <= 0) continue;
                    try {
                        FileUtils.delete((File)new File(file.getAbsolutePath()));
                        logger.info((Object)("=======>\u89c6\u9891\u6587\u4ef6\u6e05\u7406\u6210\u529f\uff1a" + file.getName()));
                    }
                    catch (Exception e) {
                        logger.info((Object)("=======>\u89c6\u9891\u6587\u4ef6\u6e05\u7406\u5931\u8d25\uff1a" + file.getName()));
                    }
                    continue;
                }
                String tmpPath = file.getAbsolutePath();
                this.clearVideoFolderFromDir(tmpPath, day);
            }
        }
    }

    private void clearNgVideoFromDir(String path, int day) {
        LocalDate lastDate = LocalDate.now().minusDays(day);
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                String fileName = file.getName();
                if (!file.isDirectory()) continue;
                if (ToolUtil.dateStrIsValid((String)fileName, (String)"yyyy-MM-dd").booleanValue()) {
                    if (lastDate.toString().compareTo(fileName) <= 0) continue;
                    try {
                        FileUtils.deleteDirectory((File)file);
                        logger.info((Object)("=======>ng\u89c6\u9891\u6587\u4ef6\u76ee\u5f55\u6e05\u7406\u6210\u529f\uff1a" + file.getName()));
                    }
                    catch (Exception e) {
                        logger.info((Object)("=======>ng\u89c6\u9891\u6587\u4ef6\u76ee\u5f55\u6e05\u7406\u5931\u8d25\uff1a" + file.getName()));
                    }
                    continue;
                }
                String tmpPath = file.getAbsolutePath();
                this.clearNgVideoFromDir(tmpPath, day);
            }
        }
    }

    private void clearFileLog(File file) {
        if (file.exists()) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                logger.info((Object)("=======>\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef\uff0cerror\uff1a" + e.getMessage()));
            }
        }
    }

    private void deleteFileLog(String path) {
        LocalDate lastDate = LocalDate.now().minusDays(10L);
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                String fileName = file.getName();
                if (!fileName.contains("_")) continue;
                String fileNoSuffix = fileName.substring(0, fileName.lastIndexOf("."));
                String fileDateStr = fileNoSuffix.substring(fileName.lastIndexOf("_") + 1);
                if (lastDate.toString().compareTo(fileDateStr) <= 0) continue;
                try {
                    FileUtils.delete((File)file);
                    continue;
                }
                catch (IOException e) {
                    logger.info((Object)("=======>\u6e05\u7406\u8fc7\u671f\u65e5\u5fd7\u6587\u4ef6\u9519\u8bef\uff0cerror\uff1a" + e.getMessage()));
                }
            }
        }
    }
}

