/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.boshiyuan.mapper.UserGroupAccessMapper;
import com.boshiyuan.mapper.UserGroupMapper;
import com.boshiyuan.mapper.UserMapper;
import com.boshiyuan.mapper.UserRuleMapper;
import com.boshiyuan.model.UserGroupAccessModel;
import com.boshiyuan.model.UserGroupModel;
import com.boshiyuan.model.UserModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.UserService;
import com.boshiyuan.util.JwtUtil;
import com.boshiyuan.util.ToolUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.util.StringUtil;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserGroupMapper userGroupMapper;
    @Autowired
    private UserRuleMapper userRuleMapper;
    @Autowired
    private UserGroupAccessMapper userGroupAccessMapper;
    private static Logger logger = Logger.getLogger(UserServiceImpl.class);

    public ResultModel findAll() {
        ResultModel result = new ResultModel();
        result.setResult((Object)this.userMapper.selectAll());
        return result;
    }

    public ResultModel<UserModel> login(UserModel user) {
        ResultModel resultModel = new ResultModel();
        UserModel userData = this.userMapper.findByUsername(user.getUsername());
        if (userData == null) {
            resultModel.setCode(-1);
            resultModel.setMsg("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        } else if (1 == userData.getStatus()) {
            StringBuffer sb = new StringBuffer(user.getPassword()).append(userData.getPwdSalt());
            byte[] bytes = sb.toString().getBytes();
            String passwd = ToolUtil.getMD5((byte[])bytes, (int)bytes.length);
            System.out.println("passwd: " + passwd);
            System.out.println("userData.getPassword(): " + userData.getPassword());
            System.out.println("passwd: " + passwd);
            System.out.println("userData.getPassword(): " + userData.getPassword());
            if (StringUtil.isNotEmpty((String)userData.getPassword()) && passwd.equals(userData.getPassword())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userId", userData.getId());
                map.put("userName", userData.getUsername());
                map.put("mobile", userData.getMobile());
                map.put("email", userData.getEmail());
                String token = JwtUtil.createJwt(map, (Long)315360000000L);
                userData.setToken(token);
                user.setId(userData.getId());
                this.userMapper.updateLoginTimes(user);
                resultModel.setMsg("\u767b\u5f55\u6210\u529f\uff01\uff01");
                resultModel.setResult((Object)userData);
            } else {
                resultModel.setCode(-1);
                resultModel.setMsg("\u5bc6\u7801\u9519\u8bef\uff01\uff01");
            }
        } else {
            resultModel.setCode(-1);
            resultModel.setMsg("\u60a8\u7684\u8d26\u6237\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u65e0\u6cd5\u767b\u9646\uff01\uff01");
        }
        return resultModel;
    }

    public UserModel findById(Long id) {
        return this.userMapper.findById(id);
    }

    @Transactional
    public int update(UserModel user) {
        user.setUpdateTime(Long.valueOf(new Date().getTime()));
        return this.userMapper.update(user);
    }

    public int updateAvatar(UserModel user) {
        return 0;
    }

    public ResultModel save(UserModel userModel) {
        ResultModel result = new ResultModel();
        if (userModel == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef\uff01");
            return result;
        }
        if (!userModel.getPassword().equals(userModel.getRepassword())) {
            result.setCode(-1);
            result.setMsg("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff01");
            return result;
        }
        UserModel user = this.userMapper.findByUsername(userModel.getUsername());
        if (user != null) {
            result.setCode(-1);
            result.setMsg("\u8be5\u7528\u6237\u540d\u5df2\u7ecf\u6ce8\u518c\u4e86\uff01");
            return result;
        }
        Long createTime = new Date().getTime();
        String salt = ToolUtil.getRandomString((int)10);
        StringBuffer sb = new StringBuffer(userModel.getPassword()).append(salt);
        byte[] bytes = sb.toString().getBytes();
        String passwd = ToolUtil.getMD5((byte[])bytes, (int)bytes.length);
        userModel.setCreateTime(createTime);
        userModel.setUpdateTime(createTime);
        userModel.setPwdSalt(salt);
        userModel.setPassword(passwd);
        userModel.setStatus((short)1);
        if (this.userMapper.save(userModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return result;
    }

    public int updateGroupAccess(UserGroupAccessModel groupAccessModel) {
        int count = 0;
        UserGroupAccessModel accessModel = this.userGroupAccessMapper.findOneByUid(groupAccessModel.getUid().longValue());
        count = accessModel != null ? this.userGroupAccessMapper.update(groupAccessModel) : this.userGroupAccessMapper.save(groupAccessModel);
        return count;
    }

    public ResultModel getImageList(HttpServletRequest request) {
        return null;
    }

    public ResultModel findUserListPage(HttpServletRequest request) {
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        ResultModel result = new ResultModel();
        List userList = this.userMapper.findUserListPage();
        PageInfo pageInfo = new PageInfo(userList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public String getGroupTitle(List<UserGroupModel> userGroupList, long groupId) {
        String groupTitle = "\u672a\u5206\u7ec4";
        for (UserGroupModel groupModel : userGroupList) {
            if (groupModel.getId() != groupId) continue;
            groupTitle = groupModel.getTitle();
            break;
        }
        return groupTitle;
    }

    public ResultModel delete(long id) {
        ResultModel resultModel = new ResultModel();
        if (id > 0L) {
            UserModel newsModel = new UserModel();
            newsModel.setId(Long.valueOf(id));
            this.userMapper.delete((Object)newsModel);
        } else {
            resultModel.setCode(-1);
            resultModel.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return resultModel;
    }

    public ResultModel userCheck(UserModel user) {
        ResultModel result = new ResultModel();
        if (null != user) {
            if (this.userMapper.updateStatus(user) < 1) {
                result.setCode(-1);
                result.setMsg("\u66f4\u65b0\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }
}

