/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.mapper.DeviceMapper;
import com.boshiyuan.mapper.TemplateMapper;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.TemplateModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.TemplateService;
import com.boshiyuan.util.ToolUtil;
import com.boshiyuan.util.UploadUtil;
import com.boshiyuan.util.ZipUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TemplateServiceImpl
implements TemplateService {
    @Autowired
    private TemplateMapper templateMapper;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private UploadConfig uploadConfig;
    @Value(value="${server.port}")
    private int SERVER_PORT;
    @Value(value="${fileupload.url}")
    private String UPLOAD_IMG_URL;

    public ResultModel findListPage(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        String deviceId = request.getParameter("deviceId");
        String cameraId = request.getParameter("cameraId");
        String detectId = request.getParameter("detectId");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        if (StringUtils.isEmpty((String)deviceId)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        TemplateModel templateModel = new TemplateModel();
        if (StringUtils.isNotEmpty((String)deviceId)) {
            templateModel.setDeviceId(deviceId);
        }
        if (StringUtils.isNotEmpty((String)cameraId)) {
            templateModel.setCameraId(cameraId);
        }
        if (StringUtils.isNotEmpty((String)detectId)) {
            templateModel.setDetectId(Integer.valueOf(Integer.parseInt(detectId)));
        }
        if (StringUtils.isNotEmpty((String)startTime)) {
            long startUtc = ToolUtil.date2TimeStamp((String)startTime, (String)"yyyy-MM-dd HH:mm");
            templateModel.setStartTime(Long.valueOf(startUtc));
        }
        if (StringUtils.isNotEmpty((String)endTime)) {
            long endUtc = ToolUtil.date2TimeStamp((String)endTime, (String)"yyyy-MM-dd HH:mm");
            templateModel.setEndTime(Long.valueOf(endUtc));
        }
        List templateList = this.templateMapper.findListPage(templateModel);
        String pathUrl = this.UPLOAD_IMG_URL + ":" + this.SERVER_PORT + "/upload/" + "template" + "/";
        for (int i = 0; i < templateList.size(); ++i) {
            if (((TemplateModel)templateList.get(i)).getUrl().startsWith("http")) continue;
            String imgUrl = pathUrl + ((TemplateModel)templateList.get(i)).getUrl();
            ((TemplateModel)templateList.get(i)).setUrl(imgUrl);
        }
        PageInfo pageInfo = new PageInfo(templateList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public ResultModel uploadTemplate(HttpServletRequest request, MultipartFile file) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        String cameraId = request.getParameter("cameraId");
        String detectId = request.getParameter("detectId");
        String createTime = request.getParameter("create_time");
        if (StringUtils.isEmpty((String)deviceId) || StringUtils.isEmpty((String)cameraId) || StringUtils.isEmpty((String)deviceId)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        if (file.isEmpty()) {
            result.setCode(-1);
            result.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        DeviceModel device = this.deviceMapper.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        String rootPath = this.uploadConfig.getUploadPath();
        String fileName = file.getOriginalFilename();
        String savePath = deviceId + "/" + cameraId + '/' + detectId;
        String uploadPath = rootPath + "template" + "/" + savePath;
        if (UploadUtil.uploadFiles((MultipartFile)file, (String)uploadPath, (String)fileName)) {
            TemplateModel templateModel = new TemplateModel();
            templateModel.setDeviceId(deviceId);
            templateModel.setCameraId(cameraId);
            templateModel.setName(fileName);
            templateModel.setSize(Long.valueOf(file.getSize()));
            templateModel.setUrl(savePath + "/" + fileName);
            if (StringUtils.isNotEmpty((String)detectId)) {
                templateModel.setDetectId(Integer.valueOf(Integer.parseInt(detectId)));
            }
            Date nowDate = new Date();
            Long nowUtc = nowDate.getTime();
            templateModel.setSaveTime(nowUtc);
            if (StringUtils.isNotEmpty((String)createTime)) {
                templateModel.setCreateTime(Integer.valueOf(Integer.parseInt(createTime)));
            }
            if (this.templateMapper.insert((Object)templateModel) > 0) {
                result.setMsg("\u4fdd\u5b58\u6210\u529f");
            } else {
                result.setCode(-1);
                result.setMsg("\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u4e0a\u4f20\u5931\u8d25");
        }
        return result;
    }

    public ResultModel deleteTemplate(TemplateModel templateModel) {
        ResultModel result = new ResultModel();
        if (templateModel == null || StringUtils.isEmpty((String)templateModel.getDeviceId())) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        if (this.templateMapper.deleteTemplate(templateModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    public int deleteTemplateById(Long id) {
        return this.templateMapper.deleteByPrimaryKey((Object)id);
    }

    public ResultModel templateExport(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String ids = request.getParameter("ids");
        String deviceId = request.getParameter("deviceId");
        if (StringUtils.isEmpty((String)deviceId)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deviceId", deviceId);
        if (StringUtils.isNotEmpty((String)ids)) {
            map.put("ids", ids);
        }
        String rootPath = this.uploadConfig.getUploadPath();
        String templatePath = rootPath + "template";
        ArrayList<File> pathList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        List templateList = this.templateMapper.findAllByDeviceId(map);
        for (TemplateModel template : templateList) {
            String filePath = templatePath + "/" + template.getUrl();
            File file = new File(filePath);
            if (!file.exists() || !file.isFile()) continue;
            File cameraFile = file.getParentFile().getParentFile();
            if (!pathList.contains(cameraFile)) {
                pathList.add(cameraFile);
            }
            if (fileList.contains(file)) continue;
            fileList.add(file);
        }
        if (pathList.size() < 1 || fileList.size() < 1) {
            result.setCode(-1);
            result.setMsg("\u6ca1\u6709\u53ef\u4ee5\u4e0b\u8f7d\u7684\u6a21\u677f\u6587\u4ef6");
            return result;
        }
        String zipName = "template_" + deviceId + ".zip";
        String dirPath = rootPath + "download" + "/" + deviceId;
        String zipPath = dirPath + "/" + zipName;
        File zipFile = new File(zipPath);
        try {
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            if (!zipFile.exists()) {
                zipFile.createNewFile();
            }
            if (ZipUtils.addListDirZip((String)zipPath, pathList, fileList).exists()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String pathUrl = this.UPLOAD_IMG_URL + ":" + this.SERVER_PORT + "/upload/" + "download" + "/" + deviceId + "/" + zipName;
                hashMap.put("url", pathUrl);
                result.setResult(hashMap);
            }
        }
        catch (IOException e) {
            result.setCode(-1);
            result.setMsg("\u9519\u8bef\uff1a" + e.getMessage());
        }
        return result;
    }
}

