/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.mapper.DeviceMapper;
import com.boshiyuan.mapper.DeviceRecordVersionMapper;
import com.boshiyuan.mapper.SystemPropertyMapper;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.DeviceRecordVersionModel;
import com.boshiyuan.model.SystemPropertyModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.SystemPropertyService;
import com.boshiyuan.util.HttpClientUtil;
import com.boshiyuan.util.ToolUtil;
import com.boshiyuan.util.UploadUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SystemPropertyServiceImpl
implements SystemPropertyService {
    @Autowired
    private SystemPropertyMapper propertyMapper;
    @Autowired
    private UploadConfig uploadConfig;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private DeviceRecordVersionMapper recordVersionMapper;
    @Value(value="${server.port}")
    private int SERVER_PORT;
    @Value(value="${fileupload.url}")
    private String UPLOAD_IMG_URL;
    private static Logger logger = Logger.getLogger(SystemPropertyServiceImpl.class);

    public List<SystemPropertyModel> findAll() {
        return this.propertyMapper.findAll();
    }

    public SystemPropertyModel findOne(int id) {
        return this.propertyMapper.findOneById(id);
    }

    public int update(SystemPropertyModel propertyModel) {
        return this.propertyMapper.update(propertyModel);
    }

    public ResultModel uploadSoftware(HttpServletRequest request, MultipartFile file) {
        ResultModel result = new ResultModel();
        if (file.isEmpty()) {
            result.setCode(-1);
            result.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String rootPath = this.uploadConfig.getUploadPath();
        String fileName = file.getOriginalFilename();
        String datePath = String.valueOf(new Date().getTime() / 1000L);
        String softPath = rootPath + "/software/";
        String uploadPath = softPath + datePath;
        if (UploadUtil.uploadFiles((MultipartFile)file, (String)uploadPath, (String)fileName)) {
            this.clearRepeatSoftwareFile(softPath, fileName, datePath);
            result.setMsg("\u6210\u529f");
        } else {
            result.setCode(-1);
            result.setMsg("\u4e0a\u4f20\u5931\u8d25");
        }
        return result;
    }

    public void clearRepeatSoftwareFile(String rootPath, String fileName, String excludeFolder) {
        File rootPathFile = new File(rootPath);
        if (rootPathFile.exists() && rootPathFile.isDirectory()) {
            String[] dirs = rootPathFile.list();
            for (int i = 0; i < dirs.length; ++i) {
                File dateDir = new File(rootPathFile, dirs[i]);
                String[] fileList = dateDir.list();
                if (fileList.length < 1) continue;
                for (int j = 0; j < fileList.length; ++j) {
                    File file = new File(dateDir, fileList[j]);
                    String tmpFileName = file.getName();
                    String parentFileName = file.getParentFile().getName();
                    if (!file.isFile() || !fileName.equals(tmpFileName) || excludeFolder.equals(parentFileName)) continue;
                    try {
                        FileUtils.delete((File)file);
                        if (file.getParentFile().listFiles().length >= 1) continue;
                        FileUtils.deleteDirectory((File)file.getParentFile());
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public ResultModel getSoftwareList() {
        ResultModel result = new ResultModel();
        String rootPath = this.uploadConfig.getUploadPath();
        String softwarePath = rootPath + "software";
        File dir = new File(softwarePath);
        ArrayList mapArrayList = new ArrayList();
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File dateDir = new File(dir, files[i]);
                String[] fileList = dateDir.list();
                for (int j = 0; j < fileList.length; ++j) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    File file = new File(dateDir, fileList[j]);
                    if (!file.exists() || !file.isFile()) continue;
                    String dirName = dateDir.getName();
                    String dateName = dirName.contains("-") ? dirName : ToolUtil.utcToString((long)(Long.parseLong(dirName) * 1000L), (String)"yyyy-MM-dd HH:mm:ss");
                    map.put("utc", dirName);
                    map.put("date", dateName);
                    map.put("filename", file.getName());
                    String pathUrl = this.UPLOAD_IMG_URL + ":" + this.SERVER_PORT + "/upload/";
                    String url = pathUrl + "software" + "/" + dateDir.getName() + "/" + file.getName();
                    map.put("url", url);
                    mapArrayList.add(map);
                }
            }
        }
        result.setResult(mapArrayList);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultModel deleteSoftware(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String fileName = request.getParameter("filename");
        String datePath = request.getParameter("date");
        if (StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)datePath)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        String rootPath = this.uploadConfig.getUploadPath();
        String softwarePath = rootPath + "software" + "/" + datePath + "/" + fileName;
        File file = new File(softwarePath);
        if (file.exists() && file.isFile()) {
            try {
                File parentFile = file.getParentFile();
                FileUtils.delete((File)file);
                if (parentFile.list().length != 0) return result;
                FileUtils.deleteDirectory((File)parentFile);
                return result;
            }
            catch (Exception e) {
                result.setCode(-1);
                result.setMsg("\u5220\u9664\u5931\u8d25");
                return result;
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return result;
    }

    public ResultModel updateSoftware(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String respString = null;
        String deviceId = request.getParameter("device_id");
        String datePath = request.getParameter("date");
        String fileName = request.getParameter("filename");
        if (StringUtils.isEmpty((String)deviceId) || StringUtils.isEmpty((String)datePath) || StringUtils.isEmpty((String)fileName)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel deviceModel = new DeviceModel();
        deviceModel.setId(Integer.valueOf(Integer.parseInt(deviceId)));
        DeviceModel device = this.deviceMapper.findOneById(deviceModel);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        Long time = new Date().getTime();
        DeviceRecordVersionModel recordVersionModel = new DeviceRecordVersionModel();
        recordVersionModel.setDeviceId(device.getDeviceId());
        recordVersionModel.setVersion(fileName);
        recordVersionModel.setUpdateTime(time);
        String rootPath = this.uploadConfig.getUploadPath();
        System.out.println(datePath);
        String filePath = rootPath + "software" + "/" + datePath + "/" + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            result.setCode(-1);
            result.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String msg = "";
        String ip = device.getIp();
        String url = "http://" + ip + ":" + "10434" + "/monitor17/ppy/update";
        logger.info((Object)("=======>request to device url:" + url));
        String param = "{ \"name\": \"" + fileName + "\"}";
        logger.info((Object)("=======>request to device:\r\n" + param));
        String param1 = "{ \"filepath\": \"" + filePath + "\"}";
        logger.info((Object)("=======>request to device:\r\n" + param1));
        respString = HttpClientUtil.doPostFile((String)url, (String)filePath);
        logger.info((Object)("=======>request to device result:\r\n" + respString));
        JSONObject resp = JSONObject.parseObject((String)respString);
        if (resp != null && resp.containsKey((Object)"code")) {
            msg = resp.getString("msg");
            result.setCode(resp.getIntValue("code"));
            result.setMsg(msg);
        } else {
            msg = "\u8bf7\u6c42\u8bbe\u5907\u670d\u52a1\u9519\u8bef";
            result.setCode(-1);
            result.setMsg(msg);
        }
        recordVersionModel.setRemark(msg);
        this.recordVersionMapper.insert((Object)recordVersionModel);
        return result;
    }

    public ResultModel softwareCheck(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String filesStr = request.getParameter("files");
        if (StringUtils.isEmpty((String)filesStr)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        String[] fileStrings = filesStr.split(",");
        List<String> fileList = Arrays.asList(fileStrings);
        if (fileList.size() < 1) {
            return result;
        }
        ArrayList<String> existList = new ArrayList<String>();
        String rootPath = this.uploadConfig.getUploadPath();
        String softPath = rootPath + "software";
        File softDirFile = new File(softPath);
        if (softDirFile.exists() && softDirFile.isDirectory()) {
            String[] files = softDirFile.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(softDirFile, files[i]);
                String tmpFileName = this.isSoftwareExist(file.getAbsolutePath(), fileList);
                if (tmpFileName == null) continue;
                existList.add(tmpFileName);
            }
        }
        result.setResult(existList);
        return result;
    }

    private String isSoftwareExist(String path, List<String> fileList) {
        String res = null;
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (!file.exists() || !file.isFile() || !fileList.contains(file.getName())) continue;
                res = file.getName();
                break;
            }
        }
        return res;
    }
}

