/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.boshiyuan.mapper.DeviceMapper;
import com.boshiyuan.mapper.NgStatisticsMapper;
import com.boshiyuan.model.DeviceRecordNodeModel;
import com.boshiyuan.model.NgCountModel;
import com.boshiyuan.model.NgStatisticsModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.model.param.DeviceStatisticsModel;
import com.boshiyuan.service.DeviceRecordNodeService;
import com.boshiyuan.service.NgStatisticsService;
import com.boshiyuan.util.ToolUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NgStatisticsServiceImpl
implements NgStatisticsService {
    @Autowired
    private NgStatisticsMapper ngStatisticsMapper;
    @Autowired
    private DeviceMapper deviceMapper;
    @Autowired
    private DeviceRecordNodeService deviceRecordNodeService;

    public int save(NgStatisticsModel ngStatisticsModel) {
        return this.ngStatisticsMapper.insert((Object)ngStatisticsModel);
    }

    public int update(NgStatisticsModel ngStatisticsModel) {
        return this.ngStatisticsMapper.updateByPrimaryKey((Object)ngStatisticsModel);
    }

    public ResultModel getAveragePeriods(String deviceId, Long startUtc, Long endUtc) {
        ResultModel result = new ResultModel();
        List averagePeriods = this.ngStatisticsMapper.calculateAveragePeriodByTimeRange(deviceId, startUtc, endUtc, "utc");
        result.setResult((Object)averagePeriods);
        return result;
    }

    public ResultModel getNgStatistics(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        String dataType = request.getParameter("type");
        String nodeDate = request.getParameter("date");
        int type = 0;
        if (StringUtils.isEmpty((String)deviceId)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8befdd");
            return result;
        }
        if (StringUtils.isNotEmpty((String)dataType)) {
            type = Integer.parseInt(dataType);
        }
        if (type > -1) {
            NgStatisticsModel ngStatisticsModel = new NgStatisticsModel();
            ngStatisticsModel.setDeviceId(deviceId);
            result.setResult((Object)this.getOneDeviceNgDataList(deviceId, Integer.parseInt(dataType), Boolean.valueOf(true)));
            return result;
        }
        if (StringUtils.isNotEmpty((String)nodeDate) && type == -1) {
            String[] dateArr = nodeDate.split("--");
            Date now = new Date();
            long startUtc = dateArr.length > 0 ? Long.valueOf(Long.parseLong(dateArr[0])) : null;
            long endUtc = now.getTime();
            if (dateArr.length > 1 && !"null".equals(dateArr[1])) {
                endUtc = Long.parseLong(dateArr[1]);
            }
            String startDateStr = ToolUtil.utcToString((long)startUtc, (String)"yyyy-MM-dd HH");
            String endDateStr = ToolUtil.utcToString((long)endUtc, (String)"yyyy-MM-dd HH");
            Date startDate = ToolUtil.stringToDate((String)startDateStr, (String)"yyyy-MM-dd HH");
            Date endDate = ToolUtil.stringToDate((String)endDateStr, (String)"yyyy-MM-dd HH");
            long tmpTime = endUtc - startUtc;
            long dayTime = 86400000L;
            long monthTime = 31L * dayTime;
            long yearTime = 365L * dayTime;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("deviceId", deviceId);
            map.put("startUtc", startUtc);
            map.put("endUtc", endUtc);
            ArrayList timeList = null;
            List ngCountModelList = null;
            if (tmpTime <= dayTime) {
                timeList = ToolUtil.getTimeByHour((Date)startDate, (Date)endDate);
                ngCountModelList = this.ngStatisticsMapper.selectNgDataByHour(map);
                ArrayList<NgCountModel> ngList = new ArrayList<NgCountModel>();
                for (Object time : timeList) {
                    ngList.add(this.getNgCountData(0, time, ngCountModelList));
                }
                result.setResult(ngList);
                return result;
            }
            if (tmpTime > dayTime && tmpTime <= monthTime) {
                timeList = ToolUtil.getDateByDay((Date)startDate, (Date)endDate);
                ngCountModelList = this.ngStatisticsMapper.selectNgDataByDay(map);
            }
            if (tmpTime > monthTime && tmpTime <= yearTime) {
                timeList = ToolUtil.getDateByMonth((Date)startDate, (Date)endDate);
                ngCountModelList = this.ngStatisticsMapper.selectNgDataByMonth(map);
            }
            if (tmpTime > yearTime) {
                timeList = ToolUtil.getDateByYear((Date)startDate, (Date)endDate);
                ngCountModelList = this.ngStatisticsMapper.selectNgDataByYear(map);
            }
            ArrayList<NgCountModel> ngList = new ArrayList<NgCountModel>();
            for (Object time : timeList) {
                ngList.add(this.getNgCountData(4, time, ngCountModelList));
            }
            result.setResult(ngList);
        }
        return result;
    }

    public ResultModel getListNgStatistics(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String pageNumStr = request.getParameter("pageNum");
        String pageSizeStr = request.getParameter("pageSize");
        String typeStr = request.getParameter("type");
        int type = StringUtils.isNotEmpty((String)typeStr) ? Integer.parseInt(typeStr) : 0;
        int pageNum = StringUtils.isNotEmpty((String)pageNumStr) ? Integer.parseInt(pageNumStr) : 1;
        int pageSize = StringUtils.isNotEmpty((String)pageSizeStr) ? Integer.parseInt(pageSizeStr) : 6;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List deviceStatisticsList = this.deviceMapper.findStatisticsListPage();
        for (DeviceStatisticsModel statisticsModel : deviceStatisticsList) {
            String deviceId = statisticsModel.getDeviceId();
            statisticsModel.setData(this.getOneDeviceNgDataList(deviceId, type, Boolean.valueOf(false)));
            List recordNodeModelList = this.deviceRecordNodeService.findRecordNodeList(deviceId);
            int count = recordNodeModelList.size();
            if (count > 0) {
                DeviceRecordNodeModel recordNodeModel = new DeviceRecordNodeModel();
                recordNodeModel.setDeviceId(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getDeviceId());
                recordNodeModel.setStartUtc(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getStartUtc());
                recordNodeModel.setStartDate(((DeviceRecordNodeModel)recordNodeModelList.get(count - 1)).getEndDate());
                recordNodeModel.setEndDate("\u81f3\u4eca");
                recordNodeModelList.add(recordNodeModel);
            }
            statisticsModel.setNode(recordNodeModelList);
        }
        System.out.println("\u65f6\u95f43\uff1a" + new Date());
        PageInfo pageInfo = new PageInfo(deviceStatisticsList);
        result.setResult((Object)pageInfo);
        return result;
    }

    public ResultModel getAllDeviceNgDataStatistics(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String typeStr = request.getParameter("type");
        int type = StringUtils.isNotEmpty((String)typeStr) ? Integer.parseInt(typeStr) : 0;
        result.setResult((Object)this.getOneDeviceNgDataList(null, type, Boolean.valueOf(true)));
        return result;
    }

    public ResultModel getAllDeviceNgDataStatistics1(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String typeStr = request.getParameter("type");
        int type = StringUtils.isNotEmpty((String)typeStr) ? Integer.parseInt(typeStr) : 0;
        result.setResult((Object)this.getOneDeviceNgDataList1(null, type, Boolean.valueOf(true)));
        return result;
    }

    private List<NgCountModel> getOneDeviceNgDataList(String deviceId, int type, Boolean timeLine) {
        List ngCountModelList = new ArrayList();
        NgStatisticsModel ngStatisticsModel = new NgStatisticsModel();
        ngStatisticsModel.setDeviceId(deviceId);
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        ArrayList timeList = new ArrayList();
        switch (type) {
            case 1: {
                calendar.add(6, -6);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByDay((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy7Day(ngStatisticsModel);
                break;
            }
            case 2: {
                calendar.add(6, -30);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByDay((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy30Day(ngStatisticsModel);
                break;
            }
            case 3: {
                calendar.add(2, -11);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByMonth((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy12Month(ngStatisticsModel);
                break;
            }
            default: {
                calendar.add(11, -24);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getTimeByHour((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy24Hour(ngStatisticsModel);
            }
        }
        ArrayList<NgCountModel> ngList = new ArrayList<NgCountModel>();
        for (Object obj : timeList) {
            ngList.add(this.getNgCountData(type, obj, ngCountModelList));
        }
        return ngList;
    }

    private List<NgCountModel> getOneDeviceNgDataList1(String deviceId, int type, Boolean timeLine) {
        List ngCountModelList = new ArrayList();
        NgStatisticsModel ngStatisticsModel = new NgStatisticsModel();
        ngStatisticsModel.setDeviceId(deviceId);
        Calendar calendar = Calendar.getInstance();
        Date endDate = calendar.getTime();
        ArrayList timeList = new ArrayList();
        switch (type) {
            case 1: {
                calendar.add(6, -6);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByDay((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy7Day(ngStatisticsModel);
                break;
            }
            case 2: {
                calendar.add(6, -30);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByDay((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy30Day(ngStatisticsModel);
                break;
            }
            case 3: {
                calendar.add(2, -11);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getDateByMonth((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectAllDevicesNgDataBy12Month(ngStatisticsModel);
                break;
            }
            default: {
                calendar.add(11, -23);
                Date startDate = calendar.getTime();
                timeList = ToolUtil.getTimeByHour((Date)startDate, (Date)endDate);
                if (!timeLine.booleanValue()) break;
                ngCountModelList = this.ngStatisticsMapper.selectNgDataBy24Hour(ngStatisticsModel);
            }
        }
        ArrayList<NgCountModel> ngList = new ArrayList<NgCountModel>();
        for (Object obj : timeList) {
            ngList.add(this.getNgCountData(type, obj, ngCountModelList));
        }
        return ngList;
    }

    public NgCountModel getNgCountData(int type, Object obj, List<NgCountModel> ngList) {
        NgCountModel ngCountModel = new NgCountModel();
        ngCountModel.setNgCount(Long.valueOf(0L));
        ngCountModel.setOkCount(Long.valueOf(0L));
        ngCountModel.setCount(Long.valueOf(0L));
        if (type > 0) {
            String dateStr = String.valueOf(obj);
            ngCountModel.setDate(dateStr);
            for (NgCountModel ng : ngList) {
                if (!ng.getDate().contains(dateStr)) continue;
                ngCountModel.setNgCount(ng.getNgCount());
                ngCountModel.setOkCount(ng.getOkCount());
                ngCountModel.setCount(ng.getCount());
                break;
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            Date tmpDate = ToolUtil.stringToDate((String)String.valueOf(obj), (String)"yyyy-MM-dd HH");
            calendar.setTime(tmpDate);
            int hour = calendar.get(11);
            ngCountModel.setHour(Integer.valueOf(hour));
            ngCountModel.setDate(hour + ":00");
            for (NgCountModel ng : ngList) {
                if (hour != ng.getHour()) continue;
                ngCountModel.setNgCount(ng.getNgCount());
                ngCountModel.setOkCount(ng.getOkCount());
                ngCountModel.setCount(ng.getCount());
                break;
            }
        }
        return ngCountModel;
    }
}

