/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.service.impl;

import com.boshiyuan.model.CustomShift;
import com.boshiyuan.service.CustomShiftRepository;
import com.boshiyuan.service.impl.ResourceNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomShiftService {
    @Autowired
    private CustomShiftRepository customShiftRepository;

    public List<CustomShift> getAllShifts() {
        return this.customShiftRepository.findAll();
    }

    public Optional<CustomShift> getShiftById(Long id) {
        return this.customShiftRepository.findById((Object)id);
    }

    public CustomShift createShift(CustomShift shift) {
        return (CustomShift)this.customShiftRepository.save((Object)shift);
    }

    public CustomShift updateShift(Long id, CustomShift shiftDetails) {
        CustomShift shift = (CustomShift)this.customShiftRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Shift not found with id: " + id));
        shift.setName(shiftDetails.getName());
        shift.setShiftStart(shiftDetails.getShiftStart());
        shift.setShiftEnd(shiftDetails.getShiftEnd());
        return (CustomShift)this.customShiftRepository.save((Object)shift);
    }

    public void deleteShift(Long id) {
        CustomShift shift = (CustomShift)this.customShiftRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Shift not found with id: " + id));
        this.customShiftRepository.delete((Object)shift);
    }
}

