/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.ServerModel;
import com.boshiyuan.model.SystemPropertyModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.ServerService;
import com.boshiyuan.service.SystemPropertyService;
import com.boshiyuan.util.ToolUtil;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/monitor17/system"})
public class SystemPropertyController {
    @Autowired
    private SystemPropertyService systemPropertyService;
    @Autowired
    private ServerService serverService;

    @RequestMapping(path={"/property"}, method={RequestMethod.GET})
    public ResultModel getProperty(HttpServletRequest request) {
        List propertyList = this.systemPropertyService.findAll();
        ResultModel result = new ResultModel();
        if (propertyList != null && propertyList.size() > 0) {
            ServerModel server = this.serverService.findOneByServerId("cdn001");
            if (server != null) {
                for (SystemPropertyModel systemProperty : propertyList) {
                    systemProperty.setWanIp(server.getWanIp());
                    systemProperty.setLanIp(server.getLanIp());
                }
            }
            result.setResult((Object)propertyList);
        }
        return result;
    }

    @RequestMapping(path={"/property/{id}"}, method={RequestMethod.GET})
    public ResultModel getPropertyInfo(@PathVariable(value="id", required=true) int id, HttpServletRequest request) {
        SystemPropertyModel propertyModel = this.systemPropertyService.findOne(id);
        ResultModel result = new ResultModel();
        if (null != propertyModel) {
            result.setResult((Object)propertyModel);
        }
        return result;
    }

    @RequestMapping(path={"/property"}, method={RequestMethod.POST})
    @Transactional
    public ResultModel updateProperty(HttpServletRequest request, @RequestBody SystemPropertyModel propertyModel) {
        ResultModel result = new ResultModel();
        if (propertyModel != null) {
            LocalTime end;
            LocalTime start;
            propertyModel.setModifyUtc(Long.valueOf(new Date().getTime()));
            String userName = ToolUtil.getUserNameFromToken((HttpServletRequest)request);
            propertyModel.setOperatorId(userName);
            if (propertyModel.getCustomShiftStart() == null && propertyModel.getCustomShiftEnd() == null) {
                propertyModel.setCustomShiftStart(null);
                propertyModel.setCustomShiftEnd(null);
            } else if (propertyModel.getCustomShiftStart() != null && propertyModel.getCustomShiftEnd() != null) {
                start = propertyModel.getCustomShiftStart();
                if (!start.isAfter(end = propertyModel.getCustomShiftEnd()) && start.equals(end)) {
                    result.setCode(-1);
                    result.setMsg("\u81ea\u5b9a\u4e49\u73ed\u6b21\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
                    return result;
                }
            } else {
                result.setCode(-1);
                result.setMsg("\u81ea\u5b9a\u4e49\u73ed\u6b21\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u540c\u65f6\u8bbe\u7f6e\u6216\u540c\u65f6\u4e0d\u8bbe\u7f6e");
                return result;
            }
            System.out.println("Received CustomShiftStart: " + propertyModel.getCustomShiftStart());
            System.out.println("Received CustomShiftEnd: " + propertyModel.getCustomShiftEnd());
            start = propertyModel.getCustomShiftStart();
            end = propertyModel.getCustomShiftEnd();
            System.out.println("Processed CustomShiftStart: " + start);
            System.out.println("Processed CustomShiftEnd: " + end);
            if (this.systemPropertyService.update(propertyModel) > 0) {
                ServerModel server = this.serverService.findOneByServerId("cdn001");
                if (!(server == null || server.getWanIp().equals(propertyModel.getWanIp()) && server.getLanIp().equals(propertyModel.getLanIp()))) {
                    ServerModel serverModel = new ServerModel();
                    serverModel.setWanIp(propertyModel.getWanIp());
                    serverModel.setLanIp(propertyModel.getLanIp());
                    this.serverService.updateServer(serverModel);
                }
                result.setMsg("\u4fdd\u5b58\u6210\u529f");
            } else {
                result.setCode(-1);
                result.setMsg("\u4fdd\u5b58\u5931\u8d25");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    @RequestMapping(path={"/software/list"}, method={RequestMethod.GET})
    public ResultModel getSoftwareList() {
        return this.systemPropertyService.getSoftwareList();
    }

    @RequestMapping(path={"/software/upload"}, method={RequestMethod.POST})
    public ResultModel uploadSoftware(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        return this.systemPropertyService.uploadSoftware(request, file);
    }

    @RequestMapping(path={"/software/delete"}, method={RequestMethod.DELETE})
    public ResultModel deleteSoftware(HttpServletRequest request) {
        return this.systemPropertyService.deleteSoftware(request);
    }

    @RequestMapping(path={"/software/update"}, method={RequestMethod.POST})
    public ResultModel updateSoftware(HttpServletRequest request) {
        return this.systemPropertyService.updateSoftware(request);
    }

    @RequestMapping(path={"/software/check"}, method={RequestMethod.GET})
    public ResultModel softwareCheck(HttpServletRequest request) {
        return this.systemPropertyService.softwareCheck(request);
    }
}

