/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.NgCountModel;
import com.boshiyuan.model.PhotoModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.service.PhotoService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor17/device"})
public class PhotoController {
    @Autowired
    private PhotoService photoService;

    @RequestMapping(path={"/images"}, method={RequestMethod.GET})
    public ResultModel getList(HttpServletRequest request) {
        return this.photoService.findListPage(request);
    }

    @RequestMapping(path={"chart/line"}, method={RequestMethod.GET})
    public ResultModel getLine(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        if (StringUtils.isNotEmpty((String)deviceId)) {
            PhotoModel photoModel = new PhotoModel();
            photoModel.setDeviceId(deviceId);
            Calendar calendar = Calendar.getInstance();
            int curHour = calendar.get(11);
            List ngModelList = this.photoService.selectPhotoData(photoModel);
            ArrayList<NgCountModel> ngList = new ArrayList<NgCountModel>();
            int startTime = (curHour + 1) % 24;
            int endTime = curHour;
            if (startTime <= endTime) {
                for (int i = startTime; i <= endTime; ++i) {
                    ngList.add(this.getNgCountData(i, ngModelList));
                }
            } else {
                int i;
                for (i = startTime; i < 24; ++i) {
                    ngList.add(this.getNgCountData(i, ngModelList));
                }
                for (i = 0; i <= endTime; ++i) {
                    ngList.add(this.getNgCountData(i, ngModelList));
                }
            }
            result.setResult(ngList);
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        return result;
    }

    public NgCountModel getNgCountData(int hour, List<NgCountModel> ngList) {
        NgCountModel ngCountModel = new NgCountModel();
        ngCountModel.setHour(Integer.valueOf(hour));
        ngCountModel.setDate(hour + ":00");
        ngCountModel.setNgCount(Long.valueOf(0L));
        ngCountModel.setCount(Long.valueOf(0L));
        for (NgCountModel ng : ngList) {
            if (hour != ng.getHour()) continue;
            ngCountModel.setNgCount(ng.getNgCount());
            ngCountModel.setCount(ng.getCount());
            break;
        }
        return ngCountModel;
    }
}

