/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.boshiyuan.model.CustomShift;
import com.boshiyuan.service.impl.CustomShiftService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/custom-shifts"})
public class CustomShiftController {
    @Autowired
    private CustomShiftService customShiftService;

    @GetMapping
    public List<CustomShift> getAllShifts() {
        return this.customShiftService.getAllShifts();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CustomShift> getShiftById(@PathVariable Long id) {
        return this.customShiftService.getShiftById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public CustomShift createShift(@RequestBody CustomShift shift) {
        return this.customShiftService.createShift(shift);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CustomShift> updateShift(@PathVariable Long id, @RequestBody CustomShift shiftDetails) {
        CustomShift updatedShift = this.customShiftService.updateShift(id, shiftDetails);
        return ResponseEntity.ok((Object)updatedShift);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> deleteShift(@PathVariable Long id) {
        this.customShiftService.deleteShift(id);
        return ResponseEntity.ok().build();
    }
}

