/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.alibaba.fastjson.JSON;
import com.boshiyuan.mapper.StreamPositionMapper;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.ServerModel;
import com.boshiyuan.model.StreamPositionModel;
import com.boshiyuan.model.VodResourceModel;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.model.param.CameraParamModel;
import com.boshiyuan.model.param.CdnParamModel;
import com.boshiyuan.model.param.PosParamModel;
import com.boshiyuan.service.DeviceService;
import com.boshiyuan.service.ServerService;
import com.boshiyuan.service.VodResourceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ccs"})
public class CcsController {
    private static Logger logger = Logger.getLogger(CcsController.class);
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private ServerService serverService;
    @Autowired
    private VodResourceService vodResourceService;
    @Autowired
    private StreamPositionMapper positionMapper;

    @RequestMapping(path={"/cdn/qos"}, method={RequestMethod.POST})
    public ResultModel qos(@RequestBody CdnParamModel paramModel) {
        logger.info((Object)("======> /cdn/qos param CdnParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ResultModel result = new ResultModel();
        logger.info((Object)("======> return /cdn/qos ==\r\n" + JSON.toJSONString((Object)result)));
        return result;
    }

    @RequestMapping(path={"/device/heartbeat"}, method={RequestMethod.GET})
    public ResultModel heartbeat(HttpServletRequest request) {
        String deviceId = request.getParameter("device_id");
        logger.info((Object)("======> /device/heartbeat param device_id==\r\n" + deviceId));
        ResultModel result = new ResultModel();
        logger.info((Object)("======> return /device/heartbeat ==\r\n" + JSON.toJSONString((Object)result)));
        return result;
    }

    @RequestMapping(path={"/device/login"}, method={RequestMethod.GET})
    public ResultModel deviceLogin(HttpServletRequest request) {
        String deviceId = request.getParameter("device_id");
        logger.info((Object)("======> /device/login param device_id==\r\n" + deviceId));
        ResultModel result = new ResultModel();
        if (StringUtils.isNotEmpty((String)deviceId)) {
            DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
            if (device != null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("deviceId", device.getDeviceId());
                hashMap.put("ip", request.getRemoteAddr());
                hashMap.put("description", device.getDescription());
                hashMap.put("utc", device.getCreateTime());
                hashMap.put("isFirstLogin", device.getIsFirstLogin());
                result.setResult(hashMap);
            } else {
                result.setCode(-1);
                result.setMsg("\u65e0\u6548\u7684\u8bbe\u5907");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        logger.info((Object)("======> return /device/login ==\r\n" + JSON.toJSONString((Object)result)));
        return result;
    }

    @RequestMapping(path={"/inlive/pushurl/query"}, method={RequestMethod.GET})
    public ResultModel getUrl(HttpServletRequest request) {
        String deviceId = request.getParameter("device_id");
        String cameraId = request.getParameter("camera_id");
        logger.info((Object)("======> /inlive/pushurl/query param device_id==\r\n" + deviceId));
        ResultModel result = new ResultModel();
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8be5\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        ServerModel server = this.serverService.findOneByServerId("cdn001");
        if (server == null) {
            result.setCode(-1);
            result.setMsg("\u65e0\u53ef\u7528\u7684cdn\u670d\u52a1");
            return result;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        long utc = new Date().getTime();
        if (StringUtils.isEmpty((String)cameraId)) {
            cameraId = "0";
        }
        String liveId = deviceId + "_" + cameraId;
        String ip = server.getLanIp();
        StringBuffer sb = new StringBuffer("http://");
        sb.append(ip).append(":");
        sb.append(server.getPushPort()).append("/");
        sb.append(liveId).append(".ts");
        sb.append("?device_id=").append(deviceId);
        sb.append("?camera_id=").append(cameraId);
        sb.append("&startms=").append(utc);
        hashMap.put("http", sb.toString());
        result.setResult(hashMap);
        logger.info((Object)("======> return /inlive/pushurl/query ==\r\n" + JSON.toJSONString((Object)result)));
        return result;
    }

    @RequestMapping(path={"/inlive/push/add"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String addLive(@RequestBody CameraParamModel paramModel) {
        logger.info((Object)("======> /inlive/push/add param CameraParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ResultModel result = new ResultModel();
        if (paramModel == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return JSON.toJSONString((Object)result);
        }
        DeviceModel device = this.deviceService.findOneByDeviceId(paramModel.getDevice_id());
        if (device != null) {
            ServerModel server = this.serverService.findOneByServerId(paramModel.getCdnid());
            if (server != null) {
                String ip = StringUtils.isNotEmpty((String)server.getWanIp()) ? server.getWanIp() : server.getLanIp();
                String liveId = paramModel.getLiveid();
                device.setLiveId(liveId);
                device.setCdnId(paramModel.getCdnid());
                String playUrl = "http://" + ip + ":" + server.getPlayPort() + "/" + liveId + ".m3u8?token=boshiyuan&gid=" + liveId;
                device.setPlayUrl(playUrl);
                device.setPushUrl(paramModel.getUrl());
                device.setPushUtc(paramModel.getUtc());
                device.setUpdateTime(Long.valueOf(new Date().getTime()));
                logger.info((Object)("======> msg deviceModel==\r\n" + JSON.toJSONString((Object)device)));
                if (this.deviceService.updateLiveData(device) < 1) {
                    result.setCode(-1);
                    result.setMsg("\u4fdd\u5b58\u5931\u8d25");
                }
            } else {
                result.setCode(-1);
                result.setMsg("\u6b64\u670d\u52a1\u672a\u914d\u7f6e");
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u8be5\u8bbe\u5907\u4e0d\u5b58\u5728");
        }
        logger.info((Object)("======> return /inlive/push/add ==\r\n" + JSON.toJSONString((Object)result)));
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(path={"/live/list"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String getLiveList(@RequestBody CdnParamModel paramModel) {
        logger.info((Object)("======> /live/list param CdnParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", 0);
        resultMap.put("msg", "\u63a5\u6536\u6210\u529f");
        resultMap.put("pageno", paramModel.getPageno());
        if (StringUtils.isEmpty((String)paramModel.getCdnid())) {
            resultMap.put("code", -1);
            resultMap.put("msg", "cdn_id\u53c2\u6570\u9519\u8bef");
            return JSON.toJSONString(resultMap);
        }
        List deviceList = this.deviceService.findDeviceListPage(paramModel);
        int length = deviceList.size();
        ArrayList mapList = new ArrayList();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (!StringUtils.isNotEmpty((String)((DeviceModel)deviceList.get(i)).getLiveId())) continue;
                map.put("liveid", ((DeviceModel)deviceList.get(i)).getLiveId());
                map.put("url", ((DeviceModel)deviceList.get(i)).getPushUrl());
                map.put("userid", ((DeviceModel)deviceList.get(i)).getDeviceId());
                map.put("status", ((DeviceModel)deviceList.get(i)).getStatus());
                map.put("recorde_hour", 0);
                map.put("meta", 2);
                map.put("enc_flag", 0);
                map.put("startutc", ((DeviceModel)deviceList.get(i)).getPushUtc());
                mapList.add(map);
            }
            resultMap.put("result", mapList);
        }
        logger.info((Object)("======> return /live/list ==\r\n" + JSON.toJSONString(resultMap)));
        String ret = JSON.toJSONString(resultMap);
        return ret;
    }

    @RequestMapping(path={"/vod/list"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String getVodList(@RequestBody CdnParamModel paramModel) {
        logger.info((Object)("======> /vod/list param CdnParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ArrayList list = new ArrayList();
        ResultModel result = new ResultModel();
        result.setResult(list);
        logger.info((Object)("======> return /vod/list ==\r\n" + JSON.toJSONString((Object)result)));
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(path={"/live/position/report"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String reportPosition(@RequestBody PosParamModel paramModel) {
        logger.info((Object)("======> /live/position/report param PosParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ResultModel result = new ResultModel();
        StreamPositionModel streamPosition = this.positionMapper.findOneById(paramModel.getLiveid());
        StreamPositionModel positionModel = new StreamPositionModel();
        positionModel.setId(paramModel.getLiveid());
        positionModel.setPos(paramModel.getPosition());
        positionModel.setFragIndex(paramModel.getLast_frags_idx());
        int count = 0;
        count = streamPosition != null ? this.positionMapper.update(positionModel) : this.positionMapper.insert((Object)positionModel);
        if (count < 1) {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        String ret = JSON.toJSONString((Object)result);
        logger.info((Object)("======> return /live/position/report ==\r\n" + ret));
        return ret;
    }

    @RequestMapping(path={"/live/status"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String liveStatus(@RequestBody CameraParamModel paramModel) {
        logger.info((Object)("======> /live/status param CameraParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ResultModel result = new ResultModel();
        if (paramModel != null) {
            ServerModel server = this.serverService.findOneByServerId(paramModel.getCdnid());
            if (server == null) {
                result.setCode(-1);
                result.setMsg("cdn\u670d\u52a1\u672a\u914d\u7f6e\uff01");
                return JSON.toJSONString((Object)result);
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef\uff01");
        }
        String ret = JSON.toJSONString((Object)result);
        logger.info((Object)("======> return /live/status ==\r\n" + ret));
        return ret;
    }

    @RequestMapping(path={"/live/position/get"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String getPosition(@RequestBody PosParamModel paramModel) {
        logger.info((Object)("======> /live/position/get param PosParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        ResultModel result = new ResultModel();
        if (paramModel != null) {
            List positionList;
            StreamPositionModel streamPosition = this.positionMapper.findOneById(paramModel.getLiveid());
            if (streamPosition == null) {
                StreamPositionModel positionModel = new StreamPositionModel();
                positionModel.setId(paramModel.getLiveid());
                positionModel.setPos(Long.valueOf(0L));
                positionModel.setFragIndex(Long.valueOf(0L));
                this.positionMapper.insert((Object)positionModel);
            }
            if ((positionList = this.positionMapper.findAll(paramModel.getLiveid())).size() > 0) {
                ArrayList mapList = new ArrayList();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < positionList.size(); ++i) {
                    map.put("liveid", ((StreamPositionModel)positionList.get(i)).getId());
                    map.put("position", ((StreamPositionModel)positionList.get(i)).getPos());
                    map.put("last_frags_idx", ((StreamPositionModel)positionList.get(i)).getFragIndex());
                    mapList.add(map);
                }
                result.setResult(mapList);
            }
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        String ret = JSON.toJSONString((Object)result);
        logger.info((Object)("======> return /live/position/get ==\r\n" + ret));
        return ret;
    }

    @RequestMapping(path={"/file/list"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String getFileList(@RequestBody CdnParamModel paramModel) {
        logger.info((Object)("======> param CdnParamModel==\r\n" + JSON.toJSONString((Object)paramModel)));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", 0);
        resultMap.put("msg", "\u63a5\u6536\u6210\u529f");
        resultMap.put("pageno", paramModel.getPageno());
        List vodList = this.vodResourceService.findListPage(paramModel);
        ArrayList mapList = new ArrayList();
        int length = vodList.size();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fileid", ((VodResourceModel)vodList.get(i)).getMedia_id());
                map.put("url", ((VodResourceModel)vodList.get(i)).getFile_name());
                map.put("meta", ((VodResourceModel)vodList.get(i)).getMeta());
                map.put("filetype", ((VodResourceModel)vodList.get(i)).getFile_type());
                mapList.add(map);
            }
            resultMap.put("result", mapList);
        }
        String result = JSON.toJSONString(resultMap);
        logger.info((Object)("======> return /file/list ==\r\n" + result));
        return result;
    }
}

