/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.model.AlarmModel;
import com.boshiyuan.model.DeviceModel;
import com.boshiyuan.model.DeviceRecordLogModel;
import com.boshiyuan.model.DeviceStateModel;
import com.boshiyuan.model.NgStatisticsModel;
import com.boshiyuan.model.ServerModel;
import com.boshiyuan.model.TemplateModel;
import com.boshiyuan.model.WorkingTimeRecord;
import com.boshiyuan.model.assit.ResultModel;
import com.boshiyuan.model.param.DeviceStatisticsModel;
import com.boshiyuan.service.AlarmService;
import com.boshiyuan.service.DeviceRecordLogService;
import com.boshiyuan.service.DeviceService;
import com.boshiyuan.service.NgStatisticsService;
import com.boshiyuan.service.PhotoService;
import com.boshiyuan.service.ServerService;
import com.boshiyuan.service.TemplateService;
import com.boshiyuan.service.WorkingTimeRecordService;
import com.boshiyuan.util.ToolUtil;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/monitor17/api"})
public class ApiController {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private ServerService serverService;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private DeviceRecordLogService recordLogService;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private NgStatisticsService ngStatisticsService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private UploadConfig uploadConfig;
    @Autowired
    private static Logger logger = Logger.getLogger(ApiController.class);
    @Autowired
    private WorkingTimeRecordService workingTimeRecordService;

    @PostMapping(value={"/working_time_record"})
    public ResponseEntity<ResultModel<Void>> addWorkingTimeRecord(@RequestBody WorkingTimeRecord record) {
        System.out.println("Received record: " + record);
        int result = this.workingTimeRecordService.insertWorkingTimeRecord(record);
        ResultModel response = new ResultModel();
        if (result > 0) {
            response.setCode(0);
            response.setMsg("\u6210\u529f");
        } else {
            response.setCode(1);
            response.setMsg("\u6dfb\u52a0\u8bb0\u5f55\u5931\u8d25");
        }
        return ResponseEntity.ok((Object)response);
    }

    @RequestMapping(path={"/heartbeat"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public ResultModel heartbeat(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("deviceId", deviceId);
        if (StringUtils.isNotEmpty((String)deviceId)) {
            DeviceModel deviceModel = new DeviceModel();
            deviceModel.setDeviceId(deviceId);
            DeviceModel device = this.deviceService.findOneDevice(deviceModel);
            hashMap.put("deviceState", device.getState());
        }
        String redisDeviceIds = (String)this.redisTemplate.boundValueOps((Object)"DEVICE_VIDEO_STATE_KEY").get();
        boolean activevideo = false;
        if (StringUtils.isNotEmpty((String)redisDeviceIds) && redisDeviceIds.contains(deviceId)) {
            activevideo = true;
        }
        hashMap.put("activevideo", activevideo);
        result.setResult(hashMap);
        return result;
    }

    @RequestMapping(path={"/heartbeat"}, method={RequestMethod.POST})
    public ResultModel getHeartbeat(HttpServletRequest request, @RequestBody DeviceStateModel stateModel) {
        String ip = ToolUtil.getHostReqFrom((HttpServletRequest)request);
        logger.info((Object)("======> /api/heartbeat param DeviceStateModel==" + JSON.toJSONString((Object)stateModel)));
        ResultModel result = new ResultModel();
        DeviceStateModel deviceStateModel = null;
        long nowUtc = new Date().getTime();
        if (stateModel != null && StringUtils.isNotEmpty((String)stateModel.getDeviceId())) {
            DeviceModel device = this.deviceService.findOneByDeviceId(stateModel.getDeviceId());
            if (device != null) {
                stateModel.setUtc(Long.valueOf(nowUtc));
                stateModel.setHeartbeatState(0);
                long onlineUtc = 0L;
                try {
                    deviceStateModel = this.getStateFromRedis(device.getDeviceId());
                    if (deviceStateModel != null) {
                        onlineUtc = deviceStateModel.getOnlineUtc();
                    }
                    stateModel.setOnlineUtc(onlineUtc);
                    String text = JSON.toJSONString((Object)stateModel);
                    this.redisTemplate.boundValueOps((Object)stateModel.getDeviceId()).set((Object)text, 1L, TimeUnit.HOURS);
                }
                catch (Exception e) {
                    logger.info((Object)("error info:" + e.getMessage()));
                    result.setMsg(e.getMessage());
                    return result;
                }
            }
            if (device != null && (!String.valueOf(device.getIp()).equals(ip) || stateModel.getCameraNum() > 0 && stateModel.getCameraNum() != device.getCameraNum())) {
                DeviceModel deviceModel = new DeviceModel();
                deviceModel.setDeviceId(device.getDeviceId());
                deviceModel.setCameraNum(stateModel.getCameraNum());
                deviceModel.setUpdateTime(Long.valueOf(new Date().getTime()));
                deviceModel.setIp(ip);
                this.deviceService.updateLiveData(deviceModel);
            }
            Boolean register = device != null;
            Boolean needVideo = device != null && device.getIsPushVideo() == 0;
            Boolean needOkImg = device != null && device.getIsPushOkPhoto() == 0;
            Boolean needSaveNgVideo = device != null && device.getIsSaveNgVideo() == 0;
            if (deviceStateModel != null && nowUtc - deviceStateModel.getOnlineUtc() > 180000L) {
                needVideo = false;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("register", register);
            hashMap.put("ip", ip);
            hashMap.put("needvideo", needVideo);
            hashMap.put("needngvideo", needSaveNgVideo);
            hashMap.put("needokimg", needOkImg);
            result.setResult(hashMap);
        } else {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
        }
        logger.info((Object)("======> return /api/heartbeat ==" + result));
        return result;
    }

    @RequestMapping(path={"/device/state"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public ResultModel getState(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        String ids = request.getParameter("ids");
        if (ids != null) {
            try {
                String[] idsArray = ids.split(",");
                ArrayList<DeviceStateModel> stateList = new ArrayList<DeviceStateModel>();
                long nowUtc = new Date().getTime();
                for (String deviceId : idsArray) {
                    DeviceStateModel deviceStateModel = this.getStateFromRedis(deviceId);
                    if (deviceStateModel == null) continue;
                    deviceStateModel.setOnlineUtc(nowUtc);
                    String text = JSON.toJSONString((Object)deviceStateModel);
                    this.redisTemplate.boundValueOps((Object)deviceStateModel.getDeviceId()).set((Object)text, 1L, TimeUnit.HOURS);
                    stateList.add(deviceStateModel);
                }
                result.setResult(stateList);
            }
            catch (Exception e) {
                logger.info((Object)("error info:" + e.getMessage()));
                result.setCode(-1);
                result.setMsg("redis \u670d\u52a1\u8fde\u63a5\u9519\u8bef\uff01");
            }
        }
        return result;
    }

    @RequestMapping(path={"/device/state/list"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public ResultModel getStateList() {
        ResultModel result = new ResultModel();
        List deviceList = this.deviceService.findAll();
        ArrayList<DeviceStateModel> stateList = new ArrayList<DeviceStateModel>();
        try {
            for (DeviceModel device : deviceList) {
                DeviceStateModel deviceStateModel = new DeviceStateModel();
                deviceStateModel.setDeviceId(device.getDeviceId());
                deviceStateModel.setHeartbeatState(1);
                DeviceStateModel stateModel = this.getStateFromRedis(device.getDeviceId());
                if (stateModel != null) {
                    deviceStateModel = stateModel;
                }
                stateList.add(deviceStateModel);
            }
            result.setResult(stateList);
        }
        catch (Exception e) {
            logger.info((Object)("error info:" + e.getMessage()));
            result.setCode(-1);
            result.setMsg("redis \u670d\u52a1\u8fde\u63a5\u9519\u8bef\uff01");
        }
        return result;
    }

    public DeviceStateModel getStateFromRedis(String deviceId) {
        String stateText = (String)this.redisTemplate.boundValueOps((Object)deviceId).get();
        DeviceStateModel stateModel = null;
        if (stateText != null) {
            JSONObject json = JSON.parseObject((String)stateText);
            stateModel = new DeviceStateModel();
            stateModel.setDeviceId(json.get((Object)"deviceId").toString());
            stateModel.setUuid(json.get((Object)"uuid").toString());
            stateModel.setDeviceBaseinfo(json.get((Object)"deviceBaseinfo").toString());
            stateModel.setDeviceState((String)json.get((Object)"deviceState"));
            stateModel.setOnlineUtc(json.getLongValue("onlineUtc"));
            Long utc = Long.parseLong(json.get((Object)"utc").toString());
            stateModel.setUtc(utc);
            Long nowUtc = new Date().getTime();
            if (nowUtc - utc >= 10000L) {
                stateModel.setHeartbeatState(1);
            }
        }
        return stateModel;
    }

    @RequestMapping(path={"/time"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public ResultModel time(HttpServletRequest request) {
        ResultModel result = new ResultModel();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("time", new Date().getTime());
        result.setResult(hashMap);
        return result;
    }

    @RequestMapping(path={"/image"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel image(HttpServletRequest request, @RequestParam(value="photo") MultipartFile file) {
        return this.photoService.uploadPhoto(request, file);
    }

    @RequestMapping(path={"/upload/resultpic"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel uploadPic(HttpServletRequest request, @RequestParam(value="photo") MultipartFile file) {
        logger.info((Object)"======> /upload/resultpic");
        return this.photoService.uploadPhoto(request, file);
    }

    @RequestMapping(path={"/inlive/pushurl/query"}, method={RequestMethod.GET})
    public String getUrl(HttpServletRequest request) {
        String deviceId = request.getParameter("device_id");
        String cameraId = request.getParameter("camera_id");
        logger.info((Object)("======> /inlive/pushurl/query param device_id==" + deviceId));
        ResultModel result = new ResultModel();
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8be5\u8bbe\u5907\u4e0d\u5b58\u5728");
            return JSON.toJSONString((Object)result);
        }
        ServerModel server = this.serverService.findOneByServerId("cdn001");
        if (server == null) {
            result.setCode(-1);
            result.setMsg("\u65e0\u53ef\u7528\u7684cdn\u670d\u52a1");
            return JSON.toJSONString((Object)result);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long utc = new Date().getTime();
        if (StringUtils.isEmpty((String)cameraId)) {
            cameraId = "0";
        }
        String liveId = deviceId + "_" + cameraId;
        String ip = server.getLanIp();
        hashMap.put("cdnip", ip);
        hashMap.put("cdnport", server.getPushPort());
        StringBuffer suffix = new StringBuffer(liveId);
        suffix.append(".ts");
        suffix.append("?device_id=").append(deviceId);
        suffix.append("&camera_id=").append(cameraId);
        suffix.append("&startms=").append(utc);
        hashMap.put("suffix", suffix.toString());
        result.setResult(hashMap);
        logger.info((Object)("======> return /inlive/pushurl/query ==" + JSON.toJSONString((Object)result)));
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(path={"/device/operate/log"}, method={RequestMethod.POST})
    public ResultModel getOperateLog(@RequestBody HashMap hashMap) {
        ResultModel result = new ResultModel();
        logger.info((Object)("======> /device/operate/log param ==" + JSON.toJSONString((Object)hashMap)));
        if (hashMap.get("deviceId") == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        String deviceId = String.valueOf(hashMap.get("deviceId"));
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        DeviceRecordLogModel logModel = new DeviceRecordLogModel();
        logModel.setDeviceId(deviceId);
        logModel.setOperator(String.valueOf(hashMap.get("recordpassword")));
        logModel.setRecordtime(String.valueOf(hashMap.get("recordtime")));
        logModel.setDescription(String.valueOf(hashMap.get("remarks")));
        logModel.setCreateTime(Long.valueOf(new Date().getTime()));
        if (this.recordLogService.add(logModel) > 0) {
            result.setMsg("\u4fdd\u5b58\u6210\u529f");
        } else {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/device/alarm/starttiming"}, method={RequestMethod.POST})
    public ResultModel addAlarmStart(@RequestBody AlarmModel alarmModel) {
        logger.info((Object)("======> /device/alarm/starttiming ==" + JSON.toJSONString((Object)alarmModel)));
        ResultModel result = new ResultModel();
        if (alarmModel == null || StringUtils.isEmpty((String)alarmModel.getDeviceId())) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        String deviceId = alarmModel.getDeviceId();
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        long utc = new Date().getTime();
        alarmModel.setStartUtc(Long.valueOf(utc));
        alarmModel.setCreateTime(Long.valueOf(utc));
        if (this.alarmService.save(alarmModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(path={"/device/alarm/finishtiming"}, method={RequestMethod.POST})
    public ResultModel alarmStop(@RequestBody AlarmModel alarmModel) {
        logger.info((Object)("======> /device/alarm/finishtiming ==" + JSON.toJSONString((Object)alarmModel)));
        ResultModel result = new ResultModel();
        if (alarmModel == null || StringUtils.isEmpty((String)alarmModel.getDeviceId())) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        String deviceId = alarmModel.getDeviceId();
        DeviceModel device = this.deviceService.findOneByDeviceId(deviceId);
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        long utc = new Date().getTime();
        alarmModel.setEndUtc(Long.valueOf(utc));
        if (this.alarmService.updateAlarmStatus(alarmModel) < 1) {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/device/detect/onceinfo"}, method={RequestMethod.POST})
    public ResultModel getStatictisData(@RequestBody HashMap hashMap) {
        logger.info((Object)("======> /device/detect/onceinfo param ==" + JSON.toJSONString((Object)hashMap)));
        ResultModel result = new ResultModel();
        if (hashMap.get("deviceId") == null) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        DeviceModel device = this.deviceService.findOneByDeviceId(String.valueOf(hashMap.get("deviceId")));
        if (device == null) {
            result.setCode(-1);
            result.setMsg("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return result;
        }
        NgStatisticsModel ngStatisticsModel = new NgStatisticsModel();
        ngStatisticsModel.setDeviceId(String.valueOf(hashMap.get("deviceId")));
        short state = (short)(Boolean.parseBoolean(String.valueOf(hashMap.get("result"))) ? 1 : 0);
        ngStatisticsModel.setState(Short.valueOf(state));
        Date nowDate = new Date();
        long utc = nowDate.getTime();
        ngStatisticsModel.setUtc(Long.valueOf(utc));
        String ngDate = ToolUtil.utcToString((long)utc, (String)"yyyy-MM-dd HH:mm:ss");
        ngStatisticsModel.setNgDate(ngDate);
        if (hashMap.get("period_time") != null) {
            ngStatisticsModel.setPeriodTime(Double.valueOf(Double.parseDouble(String.valueOf(hashMap.get("period_time")))));
        }
        if (hashMap.get("uuid") != null) {
            ngStatisticsModel.setUuid(String.valueOf(hashMap.get("uuid")));
        } else {
            ngStatisticsModel.setUuid(UUID.randomUUID().toString());
        }
        logger.info((Object)("======> /device/detect/onceinfo insert data ==" + JSON.toJSONString((Object)ngStatisticsModel)));
        if (this.ngStatisticsService.save(ngStatisticsModel) == 0) {
            result.setCode(-1);
            result.setMsg("\u4fdd\u5b58\u5931\u8d25");
        } else {
            result.setCode(0);
            result.setMsg("\u6210\u529f");
        }
        return result;
    }

    @RequestMapping(path={"/device/data/export"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public void exportToExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type = request.getParameter("type");
        String startTime = request.getParameter("startTime");
        String endTime = request.getParameter("endTime");
        String dateText = "\u6700\u8fd112\u5c0f\u65f6";
        if (StringUtils.isEmpty((String)type) && StringUtils.isNotEmpty((String)startTime) && StringUtils.isNotEmpty((String)endTime)) {
            dateText = startTime + "\u81f3" + endTime;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u76d1\u89c6\u5668\u8bbe\u5907\u4fe1\u606f\u6570\u636e\u7edf\u8ba1\u8868");
        ResultModel result = this.deviceService.getDeviceRecordNgListPage(request);
        PageInfo pageInfo = (PageInfo)result.getResult();
        List statisticsList = pageInfo.getList();
        long nowUtc = new Date().getTime();
        String dateString = ToolUtil.utcToString((long)nowUtc, (String)"yyyy_MM_dd_HH_mm");
        String fileName = dateString + ".xls";
        int rowNum = 1;
        String[] headers = new String[]{"\u8bbe\u5907id", "\u76f8\u673a\u6570", "\u68c0\u6d4b\u603b\u6570\u91cf", "ng\u6570", "ok\u6570", "\u62a5\u8b66\u6570", "\u7edf\u8ba1\u65f6\u95f4\u6bb5"};
        HSSFRow headerRow = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            HSSFCell cell = headerRow.createCell(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        for (DeviceStatisticsModel statisticsModel : statisticsList) {
            HSSFRow row = sheet.createRow(rowNum);
            row.createCell(0).setCellValue(statisticsModel.getDeviceId());
            row.createCell(1).setCellValue((double)statisticsModel.getCameraNum().intValue());
            row.createCell(2).setCellValue((double)statisticsModel.getTotalCount());
            row.createCell(3).setCellValue((double)statisticsModel.getNgCount());
            row.createCell(4).setCellValue((double)statisticsModel.getOkCount());
            row.createCell(5).setCellValue((double)statisticsModel.getAlarmCount());
            row.createCell(6).setCellValue(dateText);
            ++rowNum;
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.flushBuffer();
        workbook.write((OutputStream)response.getOutputStream());
    }

    @RequestMapping(path={"/device/template/list"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public ResultModel getTemplateList(HttpServletRequest request) {
        return this.templateService.findListPage(request);
    }

    @RequestMapping(path={"/device/template/send"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel sendTemplate(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        logger.info((Object)"======> /device/template/send");
        return this.templateService.uploadTemplate(request, file);
    }

    @RequestMapping(path={"/device/template/delete"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel deleteTemplate(@RequestBody TemplateModel templateModel) {
        return this.templateService.deleteTemplate(templateModel);
    }

    @RequestMapping(path={"/baseinfo"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel updateVersion(@RequestBody HashMap hashMap) {
        logger.info((Object)"======> /baseinfo");
        logger.info((Object)("======> request param:" + hashMap));
        return this.deviceService.updateVersion(hashMap);
    }

    @RequestMapping(path={"/device/ng/video"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"})
    public ResultModel sendNgVideo(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        logger.info((Object)"======> /device/ng/video");
        return this.deviceService.uploadNgVideo(request, file);
    }

    @RequestMapping(path={"/device/video/download"}, method={RequestMethod.GET}, produces={"application/json; charset=UTF-8"})
    public void downloadVideo(HttpServletRequest request, HttpServletResponse response) {
        String path;
        File file;
        logger.info((Object)"======> /device/video/download");
        ResultModel result = new ResultModel();
        String deviceId = request.getParameter("deviceId");
        String name = request.getParameter("file");
        String type = request.getParameter("type");
        String utc = request.getParameter("utc");
        String folder = request.getParameter("folder");
        if (StringUtils.isEmpty((String)deviceId) || StringUtils.isEmpty((String)name)) {
            result.setCode(-1);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return;
        }
        String rootPath = this.uploadConfig.getMediaRoot();
        String filePath = folder + "/" + name;
        if (StringUtils.isNotEmpty((String)type)) {
            rootPath = this.uploadConfig.getUploadPath() + "ngvideo" + "/";
            filePath = deviceId + "/" + utc + "/" + name;
        }
        if (!(file = new File(path = rootPath + filePath)).exists()) {
            return;
        }
        try {
            int len;
            FileInputStream inputStream = new FileInputStream(path);
            response.reset();
            response.setContentType("application/octet-stream");
            String filename = file.getName();
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((len = ((InputStream)inputStream).read(b)) > 0) {
                outputStream.write(b, 0, len);
            }
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            logger.info((Object)("error:" + e.getMessage()));
        }
    }
}

