/*
 * Decompiled with CFR 0.152.
 */
package com.boshiyuan;

import com.boshiyuan.config.UploadConfig;
import com.boshiyuan.interceptor.LoginInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Autowired
    private LoginInterceptor loginInterceptor;
    @Autowired
    private UploadConfig uploadConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor).addPathPatterns(new String[]{"/monitor17/**"}).excludePathPatterns(new String[]{"/monitor17/authorizations"}).excludePathPatterns(new String[]{"/monitor17/user/register"}).excludePathPatterns(new String[]{"/monitor17/api/**"}).excludePathPatterns(new String[]{"/websocket/**"}).excludePathPatterns(new String[]{"/upload/**"});
    }

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!registry.hasMappingForPattern("/static/**")) {
            registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        }
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:///" + this.uploadConfig.getUploadPath()});
        registry.addResourceHandler(new String[]{"/video/**"}).addResourceLocations(new String[]{"file:///" + this.uploadConfig.getMediaRoot()});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"PUT", "DELETE", "GET", "POST", "PATCH"}).allowedHeaders(new String[]{"*"}).exposedHeaders(new String[]{"access-control-allow-headers", "access-control-allow-methods", "access-control-allow-origin", "access-control-max-age", "X-Frame-Options", "Authorization"}).allowCredentials(false).maxAge(3600L);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
    }
}

